/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind.subtree;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;

@NonNullByDefault
public sealed interface NamespaceSelection {
    public boolean matches(QName var1);

    public record Wildcard(UnresolvedQName.Unqualified name, List<QName> qnames) implements NamespaceSelection
    {
        public Wildcard {
            qnames.stream().forEach(qname -> {
                if (!name.getLocalName().equals(qname.getLocalName())) {
                    throw new IllegalArgumentException(String.valueOf(qname) + " does not match name " + name.getLocalName());
                }
            });
        }

        @Override
        public boolean matches(QName other) {
            return this.name.getLocalName().equals(other.getLocalName());
        }
    }

    public record Exact(QName qname) implements NamespaceSelection
    {
        public Exact {
            Objects.requireNonNull(qname);
        }

        @Override
        public boolean matches(QName other) {
            return this.qname.equals((Object)other);
        }
    }
}

