/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind.subtree;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.databind.subtree.ContainmentNode;
import org.opendaylight.netconf.databind.subtree.NamespaceSelection;
import org.opendaylight.netconf.databind.subtree.Sibling;
import org.opendaylight.netconf.databind.subtree.SubtreeFilter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;

@NonNullByDefault
abstract sealed class SiblingSetBuilder
permits ContainmentNode.Builder, SubtreeFilter.Builder {
    private static final Comparator<Sibling> COMPARATOR = Comparator.comparing(NamespaceName::of);
    private final ArrayList<Sibling> siblings = new ArrayList();

    SiblingSetBuilder() {
    }

    final void addSibling(Sibling sibling) {
        this.siblings.add(Objects.requireNonNull(sibling));
    }

    final <S extends Sibling> List<S> siblings(Class<S> filter) {
        return this.siblings.stream().filter(filter::isInstance).map(filter::cast).distinct().sorted(COMPARATOR).collect(Collectors.toUnmodifiableList());
    }

    private record NamespaceName(UnresolvedQName.Unqualified name, @Nullable QNameModule namespace) implements Comparable<NamespaceName>
    {
        NamespaceName(UnresolvedQName.Unqualified name, @Nullable QNameModule namespace) {
            Objects.requireNonNull(name);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static NamespaceName of(Sibling sibling) {
            NamespaceName namespaceName;
            NamespaceSelection namespaceSelection = sibling.selection();
            Objects.requireNonNull(namespaceSelection);
            NamespaceSelection namespaceSelection2 = namespaceSelection;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NamespaceSelection.Exact.class, NamespaceSelection.Wildcard.class}, (Object)namespaceSelection2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    NamespaceSelection.Exact exact = (NamespaceSelection.Exact)namespaceSelection2;
                    try {
                        QName qName;
                        QName qname = qName = exact.qname();
                        namespaceName = new NamespaceName(qname.unbind(), qname.getModule());
                        return namespaceName;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: 
            }
            NamespaceSelection.Wildcard w = (NamespaceSelection.Wildcard)namespaceSelection2;
            namespaceName = new NamespaceName(w.name(), null);
            return namespaceName;
        }

        @Override
        public int compareTo(NamespaceName other) {
            int cmp = this.name.compareTo(other.name);
            if (cmp != 0) {
                return cmp;
            }
            QNameModule tns = this.namespace;
            QNameModule ons = other.namespace;
            if (tns == null) {
                return ons == null ? 0 : -1;
            }
            return ons == null ? 1 : tns.compareTo(ons);
        }
    }
}

