/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind.subtree;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.databind.DatabindContext;
import org.opendaylight.netconf.databind.subtree.ContainmentNode;
import org.opendaylight.netconf.databind.subtree.ContentMatchNode;
import org.opendaylight.netconf.databind.subtree.SelectionNode;
import org.opendaylight.netconf.databind.subtree.Sibling;
import org.opendaylight.netconf.databind.subtree.SiblingSet;
import org.opendaylight.netconf.databind.subtree.SiblingSetBuilder;
import org.opendaylight.netconf.databind.subtree.SubtreeFilterPrettyTree;
import org.opendaylight.netconf.databind.subtree.SubtreeFilterReader;
import org.opendaylight.netconf.databind.subtree.SubtreeFilterWriter;
import org.opendaylight.netconf.databind.subtree.SubtreeMatcher;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.PrettyTree;
import org.opendaylight.yangtools.concepts.PrettyTreeAware;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

@NonNullByDefault
public final class SubtreeFilter
implements Immutable,
PrettyTreeAware,
SiblingSet {
    private final DatabindContext databind;
    private final List<ContentMatchNode> contentMatches;
    private final List<ContainmentNode> containments;
    private final List<SelectionNode> selections;

    private SubtreeFilter(Builder builder) {
        this.databind = builder.databind;
        this.contentMatches = builder.siblings(ContentMatchNode.class);
        this.containments = builder.siblings(ContainmentNode.class);
        this.selections = builder.siblings(SelectionNode.class);
    }

    public static Builder builder(DatabindContext databind) {
        return new Builder(databind);
    }

    public static SubtreeFilter readFrom(DatabindContext databind, XMLStreamReader reader) throws XMLStreamException {
        return SubtreeFilterReader.readSubtreeFilter(reader, databind);
    }

    public PrettyTree prettyTree() {
        return new SubtreeFilterPrettyTree(this);
    }

    public void writeTo(XMLStreamWriter writer) throws XMLStreamException {
        SubtreeFilterWriter.writeSubtreeFilter(writer, this);
    }

    public boolean permitsQName(QName qname) {
        return SubtreeFilter.permitsQName(qname, this);
    }

    private static boolean permitsQName(QName qname, SiblingSet node) {
        for (ContentMatchNode contentMatch : node.contentMatches()) {
            if (!contentMatch.selection().matches(qname)) continue;
            return true;
        }
        for (SelectionNode selection : node.selections()) {
            if (!selection.selection().matches(qname)) continue;
            return true;
        }
        for (ContainmentNode containment : node.containments()) {
            if (!containment.selection().matches(qname) && !SubtreeFilter.permitsQName(qname, containment)) continue;
            return true;
        }
        return false;
    }

    public DatabindContext databind() {
        return this.databind;
    }

    public SubtreeMatcher matcher(ContainerNode data) {
        return new SubtreeMatcher(this, data);
    }

    @Override
    public List<ContentMatchNode> contentMatches() {
        return this.contentMatches;
    }

    @Override
    public List<ContainmentNode> containments() {
        return this.containments;
    }

    @Override
    public List<SelectionNode> selections() {
        return this.selections;
    }

    public int hashCode() {
        return Objects.hash(this.contentMatches, this.containments, this.selections);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SubtreeFilter)) return false;
        SubtreeFilter other = (SubtreeFilter)obj;
        if (!this.contentMatches.equals(other.contentMatches)) return false;
        if (!this.containments.equals(other.containments)) return false;
        if (!this.selections.equals(other.selections)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("siblings", (Object)this.siblings()).toString();
    }

    public static final class Builder
    extends SiblingSetBuilder {
        private final DatabindContext databind;

        private Builder(DatabindContext databind) {
            this.databind = Objects.requireNonNull(databind);
        }

        public Builder add(Sibling sibling) {
            this.addSibling(sibling);
            return this;
        }

        public SubtreeFilter build() {
            return new SubtreeFilter(this);
        }
    }
}

