/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind.subtree;

import com.google.common.xml.XmlEscapers;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.databind.subtree.AttributeMatch;
import org.opendaylight.netconf.databind.subtree.ContainmentNode;
import org.opendaylight.netconf.databind.subtree.ContentMatchNode;
import org.opendaylight.netconf.databind.subtree.NamespaceSelection;
import org.opendaylight.netconf.databind.subtree.Prefixes;
import org.opendaylight.netconf.databind.subtree.SelectionNode;
import org.opendaylight.netconf.databind.subtree.Sibling;
import org.opendaylight.netconf.databind.subtree.SiblingSet;
import org.opendaylight.netconf.databind.subtree.SubtreeFilter;
import org.opendaylight.yangtools.concepts.PrettyTree;

@NonNullByDefault
final class SubtreeFilterPrettyTree
extends PrettyTree {
    private final SubtreeFilter filter;
    private final Prefixes prefixes;

    SubtreeFilterPrettyTree(SubtreeFilter filter) {
        this.filter = Objects.requireNonNull(filter);
        this.prefixes = Prefixes.of(filter);
    }

    public void appendTo(StringBuilder sb, int depth) {
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb, (int)depth);
        sb.append("<filter type=\"subtree\">").append('\n');
        SubtreeFilterPrettyTree.appendSiblingSet(sb, depth + 1, this.prefixes, this.filter);
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb, (int)depth);
        sb.append("</filter>");
    }

    private static void appendSiblingSet(StringBuilder sb, int depth, Prefixes prefixes, SiblingSet siblings) {
        for (ContentMatchNode contentMatch : siblings.contentMatches()) {
            SubtreeFilterPrettyTree.appendContentMatch(sb, depth, prefixes, contentMatch);
        }
        for (SelectionNode selection : siblings.selections()) {
            SubtreeFilterPrettyTree.appendSelection(sb, depth, prefixes, selection);
        }
        for (ContainmentNode containment : siblings.containments()) {
            SubtreeFilterPrettyTree.appendContainment(sb, depth, prefixes, containment);
        }
    }

    private static void appendContentMatch(StringBuilder sb, int depth, Prefixes prefixes, ContentMatchNode node) {
        SubtreeFilterPrettyTree.startSibling(sb, depth, prefixes, node);
        sb.append(">\n");
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb, (int)(depth + 1));
        sb.append(node.qnameValueMap().values().stream().findFirst().orElseThrow()).append('\n');
        SubtreeFilterPrettyTree.endSibling(sb, depth, prefixes, node);
    }

    private static void appendSelection(StringBuilder sb, int depth, Prefixes prefixes, SelectionNode node) {
        SubtreeFilterPrettyTree.startSibling(sb, depth, prefixes, node);
        for (AttributeMatch am : node.attributeMatches()) {
            NamespaceSelection.Exact sel = am.selection();
            sb.append(" ");
            SubtreeFilterPrettyTree.appendPrefix(sb, prefixes, sel.qname().getNamespace().toString());
            sb.append(sel.qname().getLocalName());
            sb.append("=");
            SubtreeFilterPrettyTree.appendAttributeData(sb, String.valueOf(am.value()));
        }
        sb.append("/>\n");
    }

    private static void appendContainment(StringBuilder sb, int depth, Prefixes prefixes, ContainmentNode node) {
        SubtreeFilterPrettyTree.startSibling(sb, depth, prefixes, node);
        sb.append(">\n");
        SubtreeFilterPrettyTree.appendSiblingSet(sb, depth + 1, prefixes, node);
        SubtreeFilterPrettyTree.endSibling(sb, depth, prefixes, node);
    }

    private static void startSibling(StringBuilder sb, int depth, Prefixes prefixes, Sibling node) {
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb, (int)depth);
        sb.append('<');
        SubtreeFilterPrettyTree.appendNamespaceSelection(sb, prefixes, node);
        if (depth == 1) {
            for (Map.Entry<String, String> entry : prefixes.getNamespaceToPrefixMap().entrySet()) {
                sb.append(" xmlns:").append(entry.getValue()).append("=\"").append(entry.getKey()).append("\"");
            }
        }
    }

    private static void endSibling(StringBuilder sb, int depth, Prefixes prefixes, Sibling node) {
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb, (int)depth);
        sb.append("</");
        SubtreeFilterPrettyTree.appendNamespaceSelection(sb, prefixes, node);
        sb.append(">\n");
    }

    private static void appendNamespaceSelection(StringBuilder sb, Prefixes prefixes, Sibling node) {
        NamespaceSelection namespaceSelection = node.selection();
        Objects.requireNonNull(namespaceSelection);
        NamespaceSelection namespaceSelection2 = namespaceSelection;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NamespaceSelection.Exact.class, NamespaceSelection.Wildcard.class}, (Object)namespaceSelection2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                NamespaceSelection.Exact exact = (NamespaceSelection.Exact)namespaceSelection2;
                String ns = exact.qname().getNamespace().toString();
                SubtreeFilterPrettyTree.appendPrefix(sb, prefixes, ns);
                sb.append(exact.qname().getLocalName());
                break;
            }
            case 1: {
                NamespaceSelection.Wildcard wildcard = (NamespaceSelection.Wildcard)namespaceSelection2;
                sb.append(wildcard.name().getLocalName());
            }
        }
    }

    private static void appendPrefix(StringBuilder sb, Prefixes prefixes, String namespace) {
        sb.append(prefixes.lookUpPrefix(namespace)).append(':');
    }

    private static void appendAttributeData(StringBuilder sb, String str) {
        sb.append('\"').append(XmlEscapers.xmlAttributeEscaper().escape(str)).append('\"');
    }
}

