/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind.subtree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javanet.staxutils.SimpleNamespaceContext;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.databind.DatabindContext;
import org.opendaylight.netconf.databind.subtree.AttributeMatch;
import org.opendaylight.netconf.databind.subtree.ContainmentNode;
import org.opendaylight.netconf.databind.subtree.ContentMatchNode;
import org.opendaylight.netconf.databind.subtree.NamespaceSelection;
import org.opendaylight.netconf.databind.subtree.SelectionNode;
import org.opendaylight.netconf.databind.subtree.SiblingSetBuilder;
import org.opendaylight.netconf.databind.subtree.SubtreeFilter;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodecFactory;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
final class SubtreeFilterReader {
    private static final Logger LOG = LoggerFactory.getLogger(SubtreeFilterReader.class);

    private SubtreeFilterReader() {
    }

    static SubtreeFilter readSubtreeFilter(XMLStreamReader reader, DatabindContext databind) throws XMLStreamException {
        while (reader.hasNext() && reader.next() != 1) {
        }
        SubtreeFilter.Builder subtreeFilterBuilder = SubtreeFilter.builder(databind);
        EffectiveModelContext context = databind.modelContext();
        XmlCodecFactory codec = databind.xmlCodecs();
        HashMap<String, String> prefixToNs = new HashMap<String, String>();
        for (ModuleEffectiveStatement module : context.getModuleStatements().values()) {
            for (Map.Entry prefix : module.namespacePrefixes()) {
                prefixToNs.putIfAbsent((String)prefix.getValue(), ((QNameModule)prefix.getKey()).namespace().toString());
            }
        }
        SimpleNamespaceContext nsContext = new SimpleNamespaceContext(prefixToNs);
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)context);
        while (reader.hasNext()) {
            if (reader.next() != 1) continue;
            SubtreeFilterReader.fillElement(reader, subtreeFilterBuilder, List.of(stack), context, SubtreeFilterReader.getAttributes(reader, context), codec, (NamespaceContext)nsContext);
            break;
        }
        return subtreeFilterBuilder.build();
    }

    private static void fillElement(XMLStreamReader reader, SiblingSetBuilder builder, List<SchemaInferenceStack> parents, EffectiveModelContext context, List<AttributeMatch> attributes, XmlCodecFactory codec, NamespaceContext nsContext) throws XMLStreamException {
        Record namespace;
        javax.xml.namespace.QName elementName = reader.getName();
        String elementLocalName = elementName.getLocalPart();
        String elementNamespace = elementName.getNamespaceURI();
        ArrayList<QName> childrenQNames = new ArrayList<QName>();
        ArrayList<SchemaInferenceStack> children = new ArrayList<SchemaInferenceStack>();
        LOG.debug("Starting processing child node {}.", (Object)elementName);
        boolean wildcard = elementNamespace.isEmpty();
        for (SchemaInferenceStack parentStack : parents) {
            if (wildcard) {
                LOG.debug("Processing {} node as wildcard.", (Object)elementName);
                for (ModuleEffectiveStatement module : context.getModuleStatements().values()) {
                    SubtreeFilterReader.findNodeInModule(elementLocalName, module, parentStack, children, childrenQNames);
                }
            } else {
                LOG.debug("Processing {} node as exact.", (Object)elementName);
                Iterator childModule = context.findModuleStatements(XMLNamespace.of((String)elementNamespace)).iterator();
                if (childModule.hasNext()) {
                    SubtreeFilterReader.findNodeInModule(elementLocalName, (ModuleEffectiveStatement)childModule.next(), parentStack, children, childrenQNames);
                } else {
                    throw new XMLStreamException("Failed to lookup module with namespace %s.".formatted(elementNamespace));
                }
            }
            if (wildcard || childrenQNames.isEmpty()) continue;
            break;
        }
        if (!childrenQNames.isEmpty()) {
            if (wildcard) {
                LOG.debug("Creating Wildcard NamespaceSelection for {} node.", (Object)elementName);
                namespace = new NamespaceSelection.Wildcard(UnresolvedQName.Unqualified.of((String)elementLocalName), childrenQNames.stream().sorted().toList());
            } else {
                LOG.debug("Creating Exact NamespaceSelection for {} node.", (Object)elementName);
                namespace = new NamespaceSelection.Exact((QName)childrenQNames.getFirst());
            }
        } else {
            throw new XMLStreamException("Failed to lookup node with name %s in schema context.".formatted(elementLocalName));
        }
        block9: while (reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    LOG.debug("Starting processing children of the {} node.", (Object)elementName);
                    ContainmentNode.Builder containmentBuilder = ContainmentNode.builder(namespace);
                    SubtreeFilterReader.fillElement(reader, containmentBuilder, children, context, SubtreeFilterReader.getAttributes(reader, context), codec, nsContext);
                    while (reader.hasNext()) {
                        int event = reader.next();
                        if (event == 1) {
                            SubtreeFilterReader.fillElement(reader, containmentBuilder, children, context, SubtreeFilterReader.getAttributes(reader, context), codec, nsContext);
                            continue;
                        }
                        if (event != 2 || !elementName.equals(reader.getName())) continue;
                        LOG.debug("Reached end of {} node. Returning log level above.", (Object)elementName);
                        break;
                    }
                    builder.addSibling(containmentBuilder.build());
                    LOG.debug("Adding new ContainmentNode under {} node.", (Object)elementName);
                    return;
                }
                case 4: {
                    String text = reader.getText();
                    if (text.trim().isEmpty()) continue block9;
                    LOG.debug("Parsing content of {} node.", (Object)elementName);
                    HashMap<QName, Object> nameValueMap = new HashMap<QName, Object>();
                    for (SchemaInferenceStack entry : children) {
                        DataSchemaNode node = (DataSchemaNode)context.findDataTreeChild((Iterable)entry.toSchemaNodeIdentifier().getNodeIdentifiers()).orElseThrow(() -> new XMLStreamException("Failed to lookup node %s in schema context".formatted(entry.currentStatement())));
                        if (!(node instanceof TypedDataSchemaNode)) continue;
                        TypedDataSchemaNode typed = (TypedDataSchemaNode)node;
                        try {
                            Object value = ((XmlCodec)codec.codecFor((TypeAware)typed, (LeafrefResolver)entry)).parseValue((Object)nsContext, text);
                            nameValueMap.put(node.getQName(), value);
                            LOG.debug("Successfully parsed value for {} node.", (Object)node.getQName());
                        }
                        catch (IllegalArgumentException e) {
                            LOG.debug("Incompatible value for node {}. Ignoring.", (Object)node.getQName());
                        }
                    }
                    if (nameValueMap.isEmpty()) {
                        throw new XMLStreamException("Failed to lookup any node with compatible type for node %s.".formatted(elementLocalName));
                    }
                    builder.addSibling(new ContentMatchNode((NamespaceSelection)((Object)namespace), (Map<QName, Object>)nameValueMap));
                    LOG.debug("Adding new ContentMatch under {} node.", (Object)elementName);
                    return;
                }
                case 2: {
                    LOG.debug("Parsing SelectionNode under {} node.", (Object)elementName);
                    SelectionNode.Builder selection = SelectionNode.builder(namespace);
                    if (!attributes.isEmpty()) {
                        attributes.forEach(selection::add);
                    }
                    builder.addSibling(selection.build());
                    LOG.debug("Adding new SelectionNode under {} node.", (Object)elementName);
                    return;
                }
            }
        }
        throw new XMLStreamException("Unexpected end of the document");
    }

    private static void findNodeInModule(String elementLocalName, ModuleEffectiveStatement module, SchemaInferenceStack parentStack, ArrayList<SchemaInferenceStack> children, ArrayList<QName> childrenQNames) {
        block4: {
            QName qname = QName.create((QNameModule)module.localQNameModule(), (String)elementLocalName);
            LOG.debug("Trying to find node {} under {}.", (Object)qname, (Object)module.localQNameModule());
            try {
                Object object;
                if (!parentStack.isEmpty() && (object = parentStack.currentStatement()) instanceof ChoiceSchemaNode) {
                    ChoiceSchemaNode choice = (ChoiceSchemaNode)object;
                    LOG.debug("Searching through choice node {} for match {}.", (Object)choice.getQName(), (Object)qname);
                    for (CaseSchemaNode caseNode : choice.getCases()) {
                        Optional child = caseNode.findDataTreeChild(qname);
                        if (!child.isPresent()) continue;
                        parentStack.enterSchemaTree(caseNode.getQName());
                        SchemaTreeEffectiveStatement exact = parentStack.enterSchemaTree(qname);
                        childrenQNames.add((QName)exact.argument());
                        children.add(parentStack.copy());
                        parentStack.exit();
                        parentStack.exit();
                        break block4;
                    }
                    break block4;
                }
                SchemaTreeEffectiveStatement exact = parentStack.enterSchemaTree(qname);
                childrenQNames.add((QName)exact.argument());
                children.add(parentStack.copy());
                parentStack.exit();
            }
            catch (IllegalArgumentException iae) {
                LOG.debug("Failed to find node with name {}.", (Object)qname);
            }
        }
    }

    private static List<AttributeMatch> getAttributes(XMLStreamReader reader, EffectiveModelContext context) throws XMLStreamException {
        LOG.debug("Parsing attributes for {} node.", (Object)reader.getName());
        ArrayList<AttributeMatch> childAttributes = new ArrayList<AttributeMatch>();
        int attrCount = reader.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            javax.xml.namespace.QName attrName = reader.getAttributeName(i);
            if (attrName.getNamespaceURI().isEmpty()) {
                throw new XMLStreamException("Missing namespace for attribute " + String.valueOf(attrName));
            }
            String attrNamespace = attrName.getNamespaceURI();
            Iterator it = context.findModuleStatements(XMLNamespace.of((String)attrNamespace)).iterator();
            if (!it.hasNext()) {
                throw new XMLStreamException("Failed to lookup module schema for namespace " + attrNamespace);
            }
            NamespaceSelection.Exact exactNamespace = new NamespaceSelection.Exact(QName.create((QNameModule)((ModuleEffectiveStatement)it.next()).localQNameModule(), (String)attrName.getLocalPart()));
            String attrValue = reader.getAttributeValue(i);
            childAttributes.add(new AttributeMatch(exactNamespace, attrValue));
        }
        LOG.debug("Found {} attributes for {} node.", (Object)childAttributes.size(), (Object)reader.getName());
        return childAttributes;
    }
}

