/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind.subtree;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.databind.subtree.AttributeMatch;
import org.opendaylight.netconf.databind.subtree.ContainmentNode;
import org.opendaylight.netconf.databind.subtree.ContentMatchNode;
import org.opendaylight.netconf.databind.subtree.NamespaceSelection;
import org.opendaylight.netconf.databind.subtree.Prefixes;
import org.opendaylight.netconf.databind.subtree.SelectionNode;
import org.opendaylight.netconf.databind.subtree.SiblingSet;
import org.opendaylight.netconf.databind.subtree.SubtreeFilter;
import org.opendaylight.yangtools.yang.common.QName;

@NonNullByDefault
final class SubtreeFilterWriter {
    private SubtreeFilterWriter() {
    }

    static void writeSubtreeFilter(XMLStreamWriter writer, SubtreeFilter filter) throws XMLStreamException {
        Prefixes prefixes = Prefixes.of(filter);
        writer.writeStartElement("filter");
        writer.writeAttribute("type", "subtree");
        for (Map.Entry<String, String> entry : prefixes.getNamespaceToPrefixMap().entrySet()) {
            writer.setPrefix(entry.getValue(), entry.getKey());
            writer.writeNamespace(entry.getValue(), entry.getKey());
        }
        SubtreeFilterWriter.writeSiblings(writer, prefixes, filter);
        writer.writeEndElement();
    }

    private static void writeSiblings(XMLStreamWriter writer, Prefixes prefixes, SiblingSet siblings) throws XMLStreamException {
        for (ContentMatchNode content : siblings.contentMatches()) {
            SubtreeFilterWriter.writeContentMatch(writer, prefixes, content);
        }
        for (SelectionNode selection : siblings.selections()) {
            SubtreeFilterWriter.writeSelection(writer, prefixes, selection);
        }
        for (ContainmentNode containment : siblings.containments()) {
            SubtreeFilterWriter.writeContainment(writer, prefixes, containment);
        }
    }

    private static void writeContentMatch(XMLStreamWriter writer, Prefixes prefixes, ContentMatchNode content) throws XMLStreamException {
        SubtreeFilterWriter.writeXmlStartElement(content.selection(), prefixes, writer);
        writer.writeCharacters(String.valueOf(content.qnameValueMap().values().stream().findFirst().orElseThrow()));
        writer.writeEndElement();
    }

    private static void writeSelection(XMLStreamWriter writer, Prefixes prefixes, SelectionNode selection) throws XMLStreamException {
        SubtreeFilterWriter.writeXmlStartElement(selection.selection(), prefixes, writer);
        for (AttributeMatch attr : selection.attributeMatches()) {
            NamespaceSelection.Exact sel = attr.selection();
            String prefix = prefixes.lookUpPrefix(sel.qname().getNamespace().toString());
            writer.writeAttribute(prefix, sel.qname().getNamespace().toString(), sel.qname().getLocalName(), attr.value().toString());
        }
        writer.writeEndElement();
    }

    private static void writeContainment(XMLStreamWriter writer, Prefixes prefixes, ContainmentNode containment) throws XMLStreamException {
        SubtreeFilterWriter.writeXmlStartElement(containment.selection(), prefixes, writer);
        SubtreeFilterWriter.writeSiblings(writer, prefixes, containment);
        writer.writeEndElement();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeXmlStartElement(NamespaceSelection content, Prefixes prefixes, XMLStreamWriter writer) throws XMLStreamException {
        NamespaceSelection namespaceSelection = content;
        Objects.requireNonNull(namespaceSelection);
        NamespaceSelection namespaceSelection2 = namespaceSelection;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NamespaceSelection.Exact.class, NamespaceSelection.Wildcard.class}, (Object)namespaceSelection2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String prefix;
                QName qname;
                NamespaceSelection.Exact exact = (NamespaceSelection.Exact)namespaceSelection2;
                try {
                    QName qName;
                    qname = qName = exact.qname();
                    prefix = prefixes.lookUpPrefix(qname.getNamespace().toString());
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                writer.writeStartElement(prefix, qname.getLocalName(), qname.getNamespace().toString());
                return;
            }
            case 1: 
        }
        NamespaceSelection.Wildcard wildcard = (NamespaceSelection.Wildcard)namespaceSelection2;
        writer.writeStartElement(wildcard.name().getLocalName());
    }
}

