/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.databind.subtree;

import com.google.common.base.MoreObjects;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.databind.subtree.AttributeMatch;
import org.opendaylight.netconf.databind.subtree.ContainmentNode;
import org.opendaylight.netconf.databind.subtree.ContentMatchNode;
import org.opendaylight.netconf.databind.subtree.NamespaceSelection;
import org.opendaylight.netconf.databind.subtree.SelectionNode;
import org.opendaylight.netconf.databind.subtree.SubtreeFilter;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;

@NonNullByDefault
public final class SubtreeMatcher
implements Immutable {
    private final SubtreeFilter filter;
    private final ContainerNode data;

    public SubtreeMatcher(SubtreeFilter filter, ContainerNode data) {
        this.filter = Objects.requireNonNull(filter);
        this.data = Objects.requireNonNull(data);
    }

    public boolean matches() {
        for (ContainmentNode containment : this.filter.containments()) {
            if (SubtreeMatcher.matchContainment(containment, (DataContainerNode)this.data)) continue;
            return false;
        }
        for (ContentMatchNode contentMatch : this.filter.contentMatches()) {
            if (SubtreeMatcher.matchContent(contentMatch, (DataContainerNode)this.data)) continue;
            return false;
        }
        for (SelectionNode selection : this.filter.selections()) {
            if (SubtreeMatcher.matchSelectionNode(selection, (DataContainerNode)this.data)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchContainment(ContainmentNode filter, DataContainerNode parent) {
        boolean matched = false;
        if (SubtreeMatcher.checkSelection(filter.selection(), parent.name().getNodeType())) {
            if (!SubtreeMatcher.matchContainerInstance(filter, parent)) {
                return false;
            }
            matched = true;
        }
        for (DataContainerChild child : parent.body()) {
            block9: {
                DataContainerChild dataContainerChild;
                if (!SubtreeMatcher.checkSelection(filter.selection(), child.name().getNodeType())) continue;
                Objects.requireNonNull(child);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MapNode.class, DataContainerNode.class}, (Object)dataContainerChild, n)) {
                    case 0: {
                        MapNode map = (MapNode)dataContainerChild;
                        if (SubtreeMatcher.matchMapNode(filter, map)) {
                            break;
                        }
                        break block9;
                    }
                    case 1: {
                        DataContainerNode dc = (DataContainerNode)dataContainerChild;
                        if (SubtreeMatcher.matchContainerInstance(filter, dc)) {
                            break;
                        }
                        break block9;
                    }
                    default: {
                        break block9;
                    }
                }
                matched = true;
                continue;
            }
            return false;
        }
        return matched;
    }

    private static boolean matchContainerInstance(ContainmentNode filter, DataContainerNode data) {
        for (ContentMatchNode content : filter.contentMatches()) {
            if (SubtreeMatcher.matchContent(content, data)) continue;
            return false;
        }
        for (ContainmentNode containment : filter.containments()) {
            if (SubtreeMatcher.matchContainment(containment, data)) continue;
            return false;
        }
        for (SelectionNode selection : filter.selections()) {
            if (SubtreeMatcher.matchSelectionNode(selection, data)) continue;
            return false;
        }
        if (!(filter.contentMatches().isEmpty() && filter.selections().isEmpty() && filter.containments().isEmpty())) {
            for (DataContainerChild ch : data.body()) {
                if (SubtreeMatcher.isCovered(ch, filter)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchMapNode(ContainmentNode filter, MapNode map) {
        for (MapEntryNode entry : map.body()) {
            for (ContentMatchNode contentMatchNode : filter.contentMatches()) {
                if (SubtreeMatcher.matchContent(contentMatchNode, (DataContainerNode)entry)) continue;
                return false;
            }
            for (SelectionNode selectionNode : filter.selections()) {
                if (SubtreeMatcher.matchSelectionNode(selectionNode, (DataContainerNode)entry)) continue;
                return false;
            }
            if (!filter.containments().isEmpty()) {
                boolean matched = false;
                for (ContainmentNode containment : filter.containments()) {
                    if (!SubtreeMatcher.matchContainment(containment, (DataContainerNode)entry)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    return false;
                }
            }
            if (filter.contentMatches().isEmpty() && filter.selections().isEmpty()) continue;
            for (DataContainerChild dataContainerChild : entry.body()) {
                if (SubtreeMatcher.isCovered(dataContainerChild, filter)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchSelectionNode(SelectionNode sel, DataContainerNode data) {
        boolean selfMatch = SubtreeMatcher.checkSelection(sel.selection(), data.name().getNodeType());
        if (selfMatch && sel.attributeMatches().isEmpty()) {
            return true;
        }
        for (AttributeMatch attribute : sel.attributeMatches()) {
            if (SubtreeMatcher.matchAttributeMatch(attribute, data)) continue;
            return false;
        }
        for (DataContainerChild child : data.body()) {
            if (!SubtreeMatcher.checkSelection(sel.selection(), child.name().getNodeType())) continue;
            if (sel.attributeMatches().isEmpty()) {
                return true;
            }
            if (!(child instanceof DataContainerNode)) continue;
            DataContainerNode containerNode = (DataContainerNode)child;
            if (!SubtreeMatcher.matchAttributeSet(sel.attributeMatches(), containerNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCovered(DataContainerChild child, ContainmentNode filter) {
        QName qn = child.name().getNodeType();
        if (child instanceof LeafNode) {
            for (ContentMatchNode cm : filter.contentMatches()) {
                if (!cm.qnameValueMap().containsKey(qn)) continue;
                return true;
            }
        }
        for (SelectionNode sel : filter.selections()) {
            if (!SubtreeMatcher.checkSelection(sel.selection(), qn)) continue;
            return true;
        }
        for (ContainmentNode c : filter.containments()) {
            if (!SubtreeMatcher.checkSelection(c.selection(), qn)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchContent(ContentMatchNode contentMatch, DataContainerNode data) {
        for (Map.Entry<QName, Object> e : contentMatch.qnameValueMap().entrySet()) {
            LeafNode<?> leaf = SubtreeMatcher.findLeaf(data, e.getKey());
            if (leaf != null && Objects.equals(leaf.body(), e.getValue())) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkSelection(NamespaceSelection sel, QName qname) {
        if (sel instanceof NamespaceSelection.Exact) {
            QName q;
            NamespaceSelection.Exact exact = (NamespaceSelection.Exact)sel;
            try {
                QName qName;
                q = qName = exact.qname();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            boolean bl = q.equals((Object)qname);
            return bl;
        }
        if (!(sel instanceof NamespaceSelection.Wildcard)) return false;
        NamespaceSelection.Wildcard wc = (NamespaceSelection.Wildcard)sel;
        if (!wc.qnames().contains(qname)) return false;
        return true;
    }

    private static boolean matchAttributeSet(List<AttributeMatch> attrs, DataContainerNode data) {
        for (AttributeMatch am : attrs) {
            if (SubtreeMatcher.matchAttributeMatch(am, data)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchAttributeMatch(AttributeMatch attributeMatch, DataContainerNode data) {
        QName qname = attributeMatch.selection().qname();
        LeafNode<?> leaf = SubtreeMatcher.findLeaf(data, qname);
        return leaf != null && Objects.equals(leaf.body(), attributeMatch.value());
    }

    private static @Nullable LeafNode<?> findLeaf(DataContainerNode node, QName qname) {
        for (DataContainerChild child : node.body()) {
            LeafNode leaf;
            if (!(child instanceof LeafNode) || !(leaf = (LeafNode)child).name().getNodeType().equals((Object)qname)) continue;
            return leaf;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter.prettyTree()).add("data", (Object)this.data.prettyTree()).toString();
    }
}

