/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.keystore.legacy.impl.AbstractEncryptingRpc;
import org.opendaylight.netconf.keystore.legacy.impl.SecurityHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddPrivateKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddPrivateKeyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddPrivateKeyOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.AddPrivateKeyOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKeyBuilder;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultAddPrivateKey
extends AbstractEncryptingRpc
implements AddPrivateKey {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAddPrivateKey.class);

    DefaultAddPrivateKey(DataBroker dataBroker, AAAEncryptionService encryptionService) {
        super(dataBroker, encryptionService);
    }

    @Override
    public ListenableFuture<RpcResult<AddPrivateKeyOutput>> invoke(AddPrivateKeyInput input) {
        Map keys = input.getPrivateKey();
        if (keys == null || keys.isEmpty()) {
            return RpcResultBuilder.success((Object)new AddPrivateKeyOutputBuilder().build()).buildFuture();
        }
        LOG.debug("Adding private keys: {}", (Object)keys);
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKey> privateKeys = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKey>(keys.size());
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc._private.keys.PrivateKey key : keys.values()) {
            List<byte[]> encryptedCerts;
            byte[] encryptedPrivateKey;
            PrivateKey validPrivateKey;
            try {
                validPrivateKey = new SecurityHelper().decodePrivateKey(key.getData(), null).getPrivate();
            }
            catch (IOException e) {
                LOG.debug("Cannot decode private key {}", (Object)key, (Object)e);
                return DefaultAddPrivateKey.returnFailed("Failed to decode private key " + key.getName(), e);
            }
            try {
                encryptedPrivateKey = this.encryptEncoded(validPrivateKey.getEncoded());
            }
            catch (GeneralSecurityException e) {
                LOG.debug("Cannot encrypt private key {}", (Object)key, (Object)e);
                return DefaultAddPrivateKey.returnFailed("Failed to encrypt private key " + key.getName(), e);
            }
            List<String> certChain = key.getCertificateChain();
            if (certChain != null) {
                encryptedCerts = new ArrayList(certChain.size());
                for (String cert : certChain) {
                    byte[] encrypted;
                    byte[] encoded;
                    X509Certificate decoded;
                    try {
                        decoded = SecurityHelper.decodeCertificate(cert);
                    }
                    catch (IOException | GeneralSecurityException e) {
                        return DefaultAddPrivateKey.returnFailed("Cannot decode certificate " + cert, e);
                    }
                    try {
                        encoded = decoded.getEncoded();
                    }
                    catch (CertificateEncodingException e) {
                        return DefaultAddPrivateKey.returnFailed("Cannot re-encode certificate " + String.valueOf(decoded), e);
                    }
                    try {
                        encrypted = this.encryptEncoded(encoded);
                    }
                    catch (GeneralSecurityException e) {
                        return DefaultAddPrivateKey.returnFailed("Cannot encrypt certificate " + String.valueOf(decoded), e);
                    }
                    encryptedCerts.add(encrypted);
                }
            } else {
                encryptedCerts = List.of();
            }
            privateKeys.add(new PrivateKeyBuilder().setName(key.getName()).setData(encryptedPrivateKey).setAlgorithm(validPrivateKey.getAlgorithm()).setCertificateChain(encryptedCerts).build());
        }
        WriteTransaction tx = this.newTransaction();
        privateKeys.forEach(privateKey -> tx.put(LogicalDatastoreType.CONFIGURATION, (DataObjectIdentifier)DataObjectIdentifier.builder(Keystore.class).child(org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKey.class, (Key)privateKey.key()).build(), (DataObject)privateKey));
        return tx.commit().transform(commitInfo -> {
            LOG.debug("Added private keys: {}", keys.keySet());
            return RpcResultBuilder.success((Object)new AddPrivateKeyOutputBuilder().build()).build();
        }, MoreExecutors.directExecutor());
    }
}

