/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.collect.Maps;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.singleton.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.api.ClusterSingletonServiceProvider;
import org.opendaylight.netconf.keystore.legacy.CertifiedPrivateKey;
import org.opendaylight.netconf.keystore.legacy.NetconfKeystore;
import org.opendaylight.netconf.keystore.legacy.NetconfKeystoreService;
import org.opendaylight.netconf.keystore.legacy.impl.ConfigListener;
import org.opendaylight.netconf.keystore.legacy.impl.RpcSingleton;
import org.opendaylight.netconf.keystore.legacy.impl.SecurityHelper;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.keystore.entry.KeyCredential;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.trusted.certificates.TrustedCertificate;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={NetconfKeystoreService.class})
public final class DefaultNetconfKeystoreService
implements NetconfKeystoreService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNetconfKeystoreService.class);
    private final Set<ObjectRegistration<Consumer<NetconfKeystore>>> consumers = ConcurrentHashMap.newKeySet();
    private final AtomicReference<NetconfKeystore> keystore = new AtomicReference<Object>(null);
    private final AtomicReference<ConfigState> config = new AtomicReference<ConfigState>(ConfigState.EMPTY);
    private final SecurityHelper securityHelper = new SecurityHelper();
    private final AAAEncryptionService encryptionService;
    private final Registration configListener;
    private final Registration rpcSingleton;

    @Inject
    @Activate
    public DefaultNetconfKeystoreService(@Reference DataBroker dataBroker, @Reference RpcProviderService rpcProvider, @Reference ClusterSingletonServiceProvider cssProvider, @Reference AAAEncryptionService encryptionService) {
        this.encryptionService = Objects.requireNonNull(encryptionService);
        this.configListener = dataBroker.registerTreeChangeListener(LogicalDatastoreType.CONFIGURATION, (DataObjectReference)DataObjectIdentifier.builder(Keystore.class).build(), (DataTreeChangeListener)new ConfigListener(this));
        this.rpcSingleton = cssProvider.registerClusterSingletonService((ClusterSingletonService)new RpcSingleton(dataBroker, rpcProvider, encryptionService));
        LOG.info("NETCONF keystore service started");
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.rpcSingleton.close();
        this.configListener.close();
        LOG.info("NETCONF keystore service stopped");
    }

    @Override
    public Registration registerKeystoreConsumer(Consumer<NetconfKeystore> consumer) {
        AbstractObjectRegistration<Consumer<NetconfKeystore>> reg = new AbstractObjectRegistration<Consumer<NetconfKeystore>>(consumer){

            protected void removeRegistration() {
                DefaultNetconfKeystoreService.this.consumers.remove((Object)this);
            }
        };
        this.consumers.add((ObjectRegistration<Consumer<NetconfKeystore>>)reg);
        NetconfKeystore ks = this.keystore.getAcquire();
        if (ks != null) {
            consumer.accept(ks);
        }
        return reg;
    }

    void runUpdate(Consumer<@NonNull ConfigStateBuilder> task) {
        ConfigState prevState = this.config.getAcquire();
        ConfigStateBuilder builder = new ConfigStateBuilder(new HashMap<String, org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKey>(prevState.privateKeys), new HashMap<String, TrustedCertificate>(prevState.trustedCertificates), new HashMap<String, KeyCredential>(prevState.credentials));
        task.accept(builder);
        ConfigState newState = new ConfigState(builder.privateKeys, builder.trustedCertificates, builder.credentials);
        if (this.configListener == null || this.config.compareAndExchangeRelease(prevState, newState) != prevState) {
            return;
        }
        Throwable failure = null;
        HashMap keys = Maps.newHashMapWithExpectedSize((int)newState.privateKeys.size());
        for (org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKey privateKey : newState.privateKeys.values()) {
            PrivateKey privateKey2;
            byte[] keyBytes;
            String string = privateKey.requireName();
            try {
                keyBytes = this.encryptionService.decrypt(privateKey.requireData());
            }
            catch (GeneralSecurityException e) {
                LOG.debug("Failed to decrypt private key {}", (Object)string, (Object)e);
                failure = DefaultNetconfKeystoreService.updateFailure(failure, e);
                continue;
            }
            try {
                privateKey2 = SecurityHelper.generatePrivateKey(keyBytes, privateKey.requireAlgorithm());
            }
            catch (GeneralSecurityException e) {
                LOG.debug("Failed to generate key for {}", (Object)string, (Object)e);
                failure = DefaultNetconfKeystoreService.updateFailure(failure, e);
                continue;
            }
            List<byte[]> certChain = privateKey.requireCertificateChain();
            if (certChain.isEmpty()) {
                LOG.debug("Key {} has an empty certificate chain", (Object)string);
                failure = DefaultNetconfKeystoreService.updateFailure(failure, new IllegalArgumentException("Empty certificate chain for private key " + string));
                continue;
            }
            ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(certChain.size());
            int size = certChain.size();
            for (int i = 0; i < size; ++i) {
                X509Certificate x509cert;
                byte[] decryptCertBytes;
                try {
                    decryptCertBytes = this.encryptionService.decrypt(certChain.get(i));
                }
                catch (GeneralSecurityException e) {
                    LOG.debug("Failed to decrypt certificate chain item {} for private key {}", new Object[]{i, string, e});
                    failure = DefaultNetconfKeystoreService.updateFailure(failure, e);
                    continue;
                }
                try {
                    x509cert = this.securityHelper.generateCertificate(decryptCertBytes);
                }
                catch (GeneralSecurityException e) {
                    LOG.debug("Failed to generate certificate chain item {} for private key {}", new Object[]{i, string, e});
                    failure = DefaultNetconfKeystoreService.updateFailure(failure, e);
                    continue;
                }
                certs.add(x509cert);
            }
            keys.put(string, new CertifiedPrivateKey(privateKey2, certs));
        }
        HashMap certs = Maps.newHashMapWithExpectedSize((int)newState.trustedCertificates.size());
        for (TrustedCertificate trustedCertificate : newState.trustedCertificates.values()) {
            X509Certificate x509cert;
            byte[] bytes;
            String certName = trustedCertificate.requireName();
            try {
                bytes = this.encryptionService.decrypt(trustedCertificate.requireCertificate());
            }
            catch (GeneralSecurityException e) {
                LOG.debug("Failed to decrypt certificate for {}", (Object)certName, (Object)e);
                failure = DefaultNetconfKeystoreService.updateFailure(failure, e);
                continue;
            }
            try {
                x509cert = this.securityHelper.generateCertificate(bytes);
            }
            catch (GeneralSecurityException e) {
                LOG.debug("Failed to generate certificate for {}", (Object)certName, (Object)e);
                failure = DefaultNetconfKeystoreService.updateFailure(failure, e);
                continue;
            }
            certs.put(certName, x509cert);
        }
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)newState.credentials.size());
        for (KeyCredential cred : newState.credentials.values()) {
            KeyPair keyPair;
            byte[] publicKey;
            byte[] privateKey;
            String keyId = cred.requireKeyId();
            try {
                privateKey = this.encryptionService.decrypt(cred.getPrivateKey());
            }
            catch (GeneralSecurityException e) {
                LOG.debug("Failed to decrypt private key", (Throwable)e);
                failure = DefaultNetconfKeystoreService.updateFailure(failure, e);
                continue;
            }
            try {
                publicKey = this.encryptionService.decrypt(cred.getPublicKey());
            }
            catch (GeneralSecurityException e) {
                LOG.debug("Failed to decrypt public key", (Throwable)e);
                failure = DefaultNetconfKeystoreService.updateFailure(failure, e);
                continue;
            }
            try {
                keyPair = SecurityHelper.generateKeyPair(privateKey, publicKey, cred.requireAlgorithm());
            }
            catch (GeneralSecurityException e) {
                LOG.debug("Failed to generate key pair for {}", (Object)keyId, (Object)e);
                failure = DefaultNetconfKeystoreService.updateFailure(failure, e);
                continue;
            }
            hashMap.put(keyId, keyPair);
        }
        if (failure != null) {
            LOG.warn("New configuration is invalid, not applying it", failure);
            return;
        }
        NetconfKeystore netconfKeystore = new NetconfKeystore(keys, certs, hashMap);
        this.keystore.setRelease(netconfKeystore);
        this.consumers.forEach(consumer -> ((Consumer)consumer.getInstance()).accept(newKeystore));
    }

    private static @NonNull Throwable updateFailure(@Nullable Throwable failure, @NonNull Exception ex) {
        if (failure != null) {
            failure.addSuppressed(ex);
            return failure;
        }
        return ex;
    }

    @NonNullByDefault
    private record ConfigState(Map<String, org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKey> privateKeys, Map<String, TrustedCertificate> trustedCertificates, Map<String, KeyCredential> credentials) implements Immutable
    {
        static final ConfigState EMPTY = new ConfigState(Map.of(), Map.of(), Map.of());

        ConfigState {
            privateKeys = Map.copyOf(privateKeys);
            trustedCertificates = Map.copyOf(trustedCertificates);
            credentials = Map.copyOf(credentials);
        }
    }

    @NonNullByDefault
    record ConfigStateBuilder(HashMap<String, org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKey> privateKeys, HashMap<String, TrustedCertificate> trustedCertificates, HashMap<String, KeyCredential> credentials) implements Mutable
    {
        ConfigStateBuilder {
            Objects.requireNonNull(privateKeys);
            Objects.requireNonNull(trustedCertificates);
            Objects.requireNonNull(credentials);
        }
    }
}

