/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.util.encoders.DecoderException;
import org.eclipse.jdt.annotation.NonNull;

public final class SecurityHelper {
    private CertificateFactory certFactory;
    private Provider bcProv;

    static @NonNull PrivateKey generatePrivateKey(byte[] privateKeyBytes, String algorithm) throws GeneralSecurityException {
        return KeyFactory.getInstance(algorithm).generatePrivate(new PKCS8EncodedKeySpec(privateKeyBytes));
    }

    @NonNull X509Certificate generateCertificate(byte[] certificate) throws GeneralSecurityException {
        if (this.certFactory == null) {
            this.certFactory = CertificateFactory.getInstance("X.509");
        }
        return (X509Certificate)this.certFactory.generateCertificate(new ByteArrayInputStream(certificate));
    }

    static @NonNull KeyPair generateKeyPair(byte[] privateKeyBytes, byte[] publicKeyBytes, String algorithm) throws GeneralSecurityException {
        PrivateKey privateKey = SecurityHelper.generatePrivateKey(privateKeyBytes, algorithm);
        PublicKey publicKey = KeyFactory.getInstance(algorithm).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        return new KeyPair(publicKey, privateKey);
    }

    @VisibleForTesting
    public @NonNull KeyPair decodePrivateKey(String privateKey, String passphrase) throws IOException {
        KeyPair keyPair;
        if (this.bcProv == null) {
            Provider prov = Security.getProvider("BC");
            Provider provider = this.bcProv = prov != null ? prov : new BouncyCastleProvider();
        }
        if (privateKey == null) {
            throw new IOException("No private key present");
        }
        PEMParser keyReader = new PEMParser((Reader)new StringReader(privateKey.replace("\\n", "\n")));
        try {
            PEMKeyPair keyPair2;
            Object obj = keyReader.readObject();
            if (obj instanceof PEMEncryptedKeyPair) {
                PEMEncryptedKeyPair encrypted = (PEMEncryptedKeyPair)obj;
                keyPair2 = encrypted.decryptKeyPair(new JcePEMDecryptorProviderBuilder().setProvider(this.bcProv).build(passphrase.toCharArray()));
            } else if (obj instanceof PEMKeyPair) {
                PEMKeyPair plain;
                keyPair2 = plain = (PEMKeyPair)obj;
            } else {
                if (obj == null) {
                    throw new IOException("Invalid private key");
                }
                throw new IOException("Unhandled private key " + String.valueOf(obj.getClass()));
            }
            keyPair = new JcaPEMKeyConverter().getKeyPair(keyPair2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    keyReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DecoderException e) {
                throw new IOException("Invalid input.", e);
            }
        }
        keyReader.close();
        return keyPair;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public static @NonNull X509Certificate decodeCertificate(String certificate) throws IOException, GeneralSecurityException {
        try (PEMParser certReader = new PEMParser((Reader)new StringReader(certificate.replace("\\n", "\n")));){
            Object obj = certReader.readObject();
            if (!(obj instanceof X509CertificateHolder)) throw new IOException("Unhandled certificate " + String.valueOf(obj.getClass()));
            X509CertificateHolder cert = (X509CertificateHolder)obj;
            X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(cert);
            return x509Certificate;
        }
        catch (DecoderException e) {
            throw new IOException("Invalid input.", e);
        }
    }
}

