/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc._private.keys;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc._private.keys.PrivateKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc._private.keys.PrivateKeyKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;

public class PrivateKeyBuilder {
    private List<String> _certificateChain;
    private String _data;
    private String _name;
    private PrivateKeyKey key;
    Map<Class<? extends Augmentation<PrivateKey>>, Augmentation<PrivateKey>> augmentation = Map.of();

    public PrivateKeyBuilder() {
    }

    public PrivateKeyBuilder(PrivateKey base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PrivateKey>>, Augmentation<PrivateKey>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._certificateChain = base.getCertificateChain();
        this._data = base.getData();
    }

    public PrivateKeyKey key() {
        return this.key;
    }

    public List<String> getCertificateChain() {
        return this._certificateChain;
    }

    public String getData() {
        return this._data;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<PrivateKey>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PrivateKeyBuilder withKey(PrivateKeyKey key) {
        this.key = key;
        return this;
    }

    public PrivateKeyBuilder setCertificateChain(List<String> values) {
        this._certificateChain = values;
        return this;
    }

    public PrivateKeyBuilder setData(String value) {
        this._data = value;
        return this;
    }

    public PrivateKeyBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public PrivateKeyBuilder addAugmentation(Augmentation<PrivateKey> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PrivateKey>>, Augmentation<PrivateKey>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public PrivateKeyBuilder removeAugmentation(Class<? extends Augmentation<PrivateKey>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull PrivateKey build() {
        return new PrivateKeyImpl(this);
    }

    private static final class PrivateKeyImpl
    extends AbstractEntryObject<PrivateKey, PrivateKeyKey>
    implements PrivateKey {
        private final List<String> _certificateChain;
        private final String _data;
        private final String _name;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PrivateKeyImpl(PrivateKeyBuilder base) {
            super(base.augmentation, (Key)PrivateKeyImpl.extractKey(base));
            PrivateKeyKey key = (PrivateKeyKey)this.key();
            this._name = key.getName();
            this._certificateChain = base.getCertificateChain();
            this._data = base.getData();
        }

        private static @NonNull PrivateKeyKey extractKey(PrivateKeyBuilder base) {
            PrivateKeyKey key = base.key();
            return key != null ? key : new PrivateKeyKey(base.getName());
        }

        @Override
        public List<String> getCertificateChain() {
            return this._certificateChain;
        }

        @Override
        public String getData() {
            return this._data;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = PrivateKey.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return PrivateKey.bindingEquals(this, obj);
        }

        public String toString() {
            return PrivateKey.bindingToString(this);
        }
    }
}

