/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.util.concurrent.ListenableFuture;
import java.security.GeneralSecurityException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.netconf.keystore.legacy.impl.AbstractRpc;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;

abstract class AbstractEncryptingRpc
extends AbstractRpc {
    private final AAAEncryptionService encryptionService;

    AbstractEncryptingRpc(DataBroker dataBroker, AAAEncryptionService encryptionService) {
        super(dataBroker);
        this.encryptionService = Objects.requireNonNull(encryptionService);
    }

    final byte @NonNull [] encryptEncoded(byte[] bytes) throws GeneralSecurityException {
        return this.encryptionService.encrypt(bytes);
    }

    static final <T> @NonNull ListenableFuture<RpcResult<T>> returnFailed(String message, Exception cause) {
        return RpcResultBuilder.failed().withError(ErrorType.APPLICATION, message, (Throwable)cause).buildFuture();
    }
}

