/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.netconf.keystore.legacy.impl.AbstractRpc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemoveTrustedCertificate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemoveTrustedCertificateInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemoveTrustedCertificateOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.RemoveTrustedCertificateOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.trusted.certificates.TrustedCertificate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.trusted.certificates.TrustedCertificateKey;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultRemoveTrustedCertificate
extends AbstractRpc
implements RemoveTrustedCertificate {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRemoveTrustedCertificate.class);

    DefaultRemoveTrustedCertificate(DataBroker dataBroker) {
        super(dataBroker);
    }

    @Override
    public ListenableFuture<RpcResult<RemoveTrustedCertificateOutput>> invoke(RemoveTrustedCertificateInput input) {
        Set<String> names = input.getName();
        if (names == null || names.isEmpty()) {
            return RpcResultBuilder.success((Object)new RemoveTrustedCertificateOutputBuilder().build()).buildFuture();
        }
        Set keys = names.stream().map(TrustedCertificateKey::new).collect(Collectors.toSet());
        LOG.debug("Removing trusted certificates: {}", keys);
        WriteTransaction tx = this.newTransaction();
        for (TrustedCertificateKey key : keys) {
            tx.delete(LogicalDatastoreType.CONFIGURATION, (DataObjectIdentifier)DataObjectIdentifier.builder(Keystore.class).child(TrustedCertificate.class, (Key)key).build());
        }
        return tx.commit().transform(commitInfo -> {
            LOG.debug("Removed trusted certificates: {}", (Object)keys);
            return RpcResultBuilder.success((Object)new RemoveTrustedCertificateOutputBuilder().build()).build();
        }, MoreExecutors.directExecutor());
    }
}

