/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.keystore.legacy.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.aaa.encrypt.AAAEncryptionService;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.singleton.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.api.ServiceGroupIdentifier;
import org.opendaylight.netconf.keystore.legacy.impl.DefaultAddKeystoreEntry;
import org.opendaylight.netconf.keystore.legacy.impl.DefaultAddPrivateKey;
import org.opendaylight.netconf.keystore.legacy.impl.DefaultAddTrustedCertificate;
import org.opendaylight.netconf.keystore.legacy.impl.DefaultRemoveKeystoreEntry;
import org.opendaylight.netconf.keystore.legacy.impl.DefaultRemovePrivateKey;
import org.opendaylight.netconf.keystore.legacy.impl.DefaultRemoveTrustedCertificate;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RpcSingleton
implements ClusterSingletonService {
    private static final Logger LOG = LoggerFactory.getLogger(RpcSingleton.class);
    private static final @NonNull ServiceGroupIdentifier SGI = new ServiceGroupIdentifier("netconf-keystore-rpc");
    private final AAAEncryptionService encryptionService;
    private final RpcProviderService rpcProvider;
    private final DataBroker dataBroker;
    private Registration reg;

    RpcSingleton(DataBroker dataBroker, RpcProviderService rpcProvider, AAAEncryptionService encryptionService) {
        this.dataBroker = Objects.requireNonNull(dataBroker);
        this.rpcProvider = Objects.requireNonNull(rpcProvider);
        this.encryptionService = Objects.requireNonNull(encryptionService);
    }

    public ServiceGroupIdentifier getIdentifier() {
        return SGI;
    }

    public void instantiateServiceInstance() {
        if (this.reg != null) {
            LOG.warn("Instiatiating while already running, very weird", new Throwable());
            return;
        }
        LOG.debug("Registering RPC implementations");
        this.reg = this.rpcProvider.registerRpcImplementations(new Rpc[]{new DefaultAddKeystoreEntry(this.dataBroker, this.encryptionService), new DefaultRemoveKeystoreEntry(this.dataBroker), new DefaultAddPrivateKey(this.dataBroker, this.encryptionService), new DefaultRemovePrivateKey(this.dataBroker), new DefaultAddTrustedCertificate(this.dataBroker, this.encryptionService), new DefaultRemoveTrustedCertificate(this.dataBroker)});
        LOG.info("This node is now owning NETCONF keystore configuration");
    }

    public ListenableFuture<?> closeServiceInstance() {
        if (this.reg != null) {
            LOG.debug("Unregistering RPC implementations");
            this.reg.close();
            this.reg = null;
            LOG.info("This node is no longer owning NETCONF keystore configuration");
        }
        return Futures.immediateVoidFuture();
    }
}

