/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.Keystore;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.KeystoreEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.PrivateKeys;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.TrustedCertificates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708._private.keys.PrivateKeyKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.keystore.entry.KeyCredential;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.keystore.entry.KeyCredentialKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.trusted.certificates.TrustedCertificate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.trusted.certificates.TrustedCertificateKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class KeystoreBuilder {
    private Map<KeyCredentialKey, KeyCredential> _keyCredential;
    private Map<PrivateKeyKey, PrivateKey> _privateKey;
    private Map<TrustedCertificateKey, TrustedCertificate> _trustedCertificate;
    Map<Class<? extends Augmentation<Keystore>>, Augmentation<Keystore>> augmentation = Map.of();

    public KeystoreBuilder() {
    }

    public KeystoreBuilder(KeystoreEntry arg) {
        this._keyCredential = arg.getKeyCredential();
    }

    public KeystoreBuilder(PrivateKeys arg) {
        this._privateKey = arg.getPrivateKey();
    }

    public KeystoreBuilder(TrustedCertificates arg) {
        this._trustedCertificate = arg.getTrustedCertificate();
    }

    public KeystoreBuilder(Keystore base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Keystore>>, Augmentation<Keystore>>(aug);
        }
        this._keyCredential = base.getKeyCredential();
        this._privateKey = base.getPrivateKey();
        this._trustedCertificate = base.getTrustedCertificate();
    }

    public void fieldsFrom(Grouping arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof KeystoreEntry) {
            castArg = (KeystoreEntry)arg;
            this._keyCredential = castArg.getKeyCredential();
            isValidArg = true;
        }
        if (arg instanceof TrustedCertificates) {
            castArg = (TrustedCertificates)arg;
            this._trustedCertificate = castArg.getTrustedCertificate();
            isValidArg = true;
        }
        if (arg instanceof PrivateKeys) {
            castArg = (PrivateKeys)arg;
            this._privateKey = castArg.getPrivateKey();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[KeystoreEntry, TrustedCertificates, PrivateKeys]");
    }

    public static @NonNull Keystore empty() {
        return LazyEmpty.INSTANCE;
    }

    public Map<KeyCredentialKey, KeyCredential> getKeyCredential() {
        return this._keyCredential;
    }

    public Map<PrivateKeyKey, PrivateKey> getPrivateKey() {
        return this._privateKey;
    }

    public Map<TrustedCertificateKey, TrustedCertificate> getTrustedCertificate() {
        return this._trustedCertificate;
    }

    public <E$$ extends Augmentation<Keystore>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public KeystoreBuilder setKeyCredential(Map<KeyCredentialKey, KeyCredential> values) {
        this._keyCredential = values;
        return this;
    }

    public KeystoreBuilder setPrivateKey(Map<PrivateKeyKey, PrivateKey> values) {
        this._privateKey = values;
        return this;
    }

    public KeystoreBuilder setTrustedCertificate(Map<TrustedCertificateKey, TrustedCertificate> values) {
        this._trustedCertificate = values;
        return this;
    }

    public KeystoreBuilder addAugmentation(Augmentation<Keystore> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Keystore>>, Augmentation<Keystore>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public KeystoreBuilder removeAugmentation(Class<? extends Augmentation<Keystore>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Keystore build() {
        return new KeystoreImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Keystore INSTANCE = new KeystoreBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class KeystoreImpl
    extends AbstractAugmentable<Keystore>
    implements Keystore {
        private final Map<KeyCredentialKey, KeyCredential> _keyCredential;
        private final Map<PrivateKeyKey, PrivateKey> _privateKey;
        private final Map<TrustedCertificateKey, TrustedCertificate> _trustedCertificate;
        private int hash = 0;
        private volatile boolean hashValid = false;

        KeystoreImpl(KeystoreBuilder base) {
            super(base.augmentation);
            this._keyCredential = CodeHelpers.emptyToNull(base.getKeyCredential());
            this._privateKey = CodeHelpers.emptyToNull(base.getPrivateKey());
            this._trustedCertificate = CodeHelpers.emptyToNull(base.getTrustedCertificate());
        }

        @Override
        public Map<KeyCredentialKey, KeyCredential> getKeyCredential() {
            return this._keyCredential;
        }

        @Override
        public Map<PrivateKeyKey, PrivateKey> getPrivateKey() {
            return this._privateKey;
        }

        @Override
        public Map<TrustedCertificateKey, TrustedCertificate> getTrustedCertificate() {
            return this._trustedCertificate;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Keystore.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Keystore.bindingEquals(this, obj);
        }

        public String toString() {
            return Keystore.bindingToString(this);
        }
    }
}

