/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc.keystore.entry;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc.keystore.entry.KeyCredential;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc.keystore.entry.KeyCredentialKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;

public class KeyCredentialBuilder {
    private String _keyId;
    private String _passphrase;
    private String _privateKey;
    private KeyCredentialKey key;
    Map<Class<? extends Augmentation<KeyCredential>>, Augmentation<KeyCredential>> augmentation = Map.of();

    public KeyCredentialBuilder() {
    }

    public KeyCredentialBuilder(KeyCredential base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<KeyCredential>>, Augmentation<KeyCredential>>(aug);
        }
        this.key = base.key();
        this._keyId = base.getKeyId();
        this._passphrase = base.getPassphrase();
        this._privateKey = base.getPrivateKey();
    }

    public KeyCredentialKey key() {
        return this.key;
    }

    public String getKeyId() {
        return this._keyId;
    }

    public String getPassphrase() {
        return this._passphrase;
    }

    public String getPrivateKey() {
        return this._privateKey;
    }

    public <E$$ extends Augmentation<KeyCredential>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public KeyCredentialBuilder withKey(KeyCredentialKey key) {
        this.key = key;
        return this;
    }

    public KeyCredentialBuilder setKeyId(String value) {
        this._keyId = value;
        return this;
    }

    public KeyCredentialBuilder setPassphrase(String value) {
        this._passphrase = value;
        return this;
    }

    public KeyCredentialBuilder setPrivateKey(String value) {
        this._privateKey = value;
        return this;
    }

    public KeyCredentialBuilder addAugmentation(Augmentation<KeyCredential> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<KeyCredential>>, Augmentation<KeyCredential>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public KeyCredentialBuilder removeAugmentation(Class<? extends Augmentation<KeyCredential>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull KeyCredential build() {
        return new KeyCredentialImpl(this);
    }

    private static final class KeyCredentialImpl
    extends AbstractEntryObject<KeyCredential, KeyCredentialKey>
    implements KeyCredential {
        private final String _keyId;
        private final String _passphrase;
        private final String _privateKey;
        private int hash = 0;
        private volatile boolean hashValid = false;

        KeyCredentialImpl(KeyCredentialBuilder base) {
            super(base.augmentation, (Key)KeyCredentialImpl.extractKey(base));
            KeyCredentialKey key = (KeyCredentialKey)this.key();
            this._keyId = key.getKeyId();
            this._passphrase = base.getPassphrase();
            this._privateKey = base.getPrivateKey();
        }

        private static @NonNull KeyCredentialKey extractKey(KeyCredentialBuilder base) {
            KeyCredentialKey key = base.key();
            return key != null ? key : new KeyCredentialKey(base.getKeyId());
        }

        @Override
        public String getKeyId() {
            return this._keyId;
        }

        @Override
        public String getPassphrase() {
            return this._passphrase;
        }

        @Override
        public String getPrivateKey() {
            return this._privateKey;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = KeyCredential.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return KeyCredential.bindingEquals(this, obj);
        }

        public String toString() {
            return KeyCredential.bindingToString(this);
        }
    }
}

