/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc.trusted.certificates;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc.trusted.certificates.TrustedCertificate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.keystore.rev240708.rpc.trusted.certificates.TrustedCertificateKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;

public class TrustedCertificateBuilder {
    private String _certificate;
    private String _name;
    private TrustedCertificateKey key;
    Map<Class<? extends Augmentation<TrustedCertificate>>, Augmentation<TrustedCertificate>> augmentation = Map.of();

    public TrustedCertificateBuilder() {
    }

    public TrustedCertificateBuilder(TrustedCertificate base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrustedCertificate>>, Augmentation<TrustedCertificate>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._certificate = base.getCertificate();
    }

    public TrustedCertificateKey key() {
        return this.key;
    }

    public String getCertificate() {
        return this._certificate;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<TrustedCertificate>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TrustedCertificateBuilder withKey(TrustedCertificateKey key) {
        this.key = key;
        return this;
    }

    public TrustedCertificateBuilder setCertificate(String value) {
        this._certificate = value;
        return this;
    }

    public TrustedCertificateBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public TrustedCertificateBuilder addAugmentation(Augmentation<TrustedCertificate> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TrustedCertificate>>, Augmentation<TrustedCertificate>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TrustedCertificateBuilder removeAugmentation(Class<? extends Augmentation<TrustedCertificate>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull TrustedCertificate build() {
        return new TrustedCertificateImpl(this);
    }

    private static final class TrustedCertificateImpl
    extends AbstractEntryObject<TrustedCertificate, TrustedCertificateKey>
    implements TrustedCertificate {
        private final String _certificate;
        private final String _name;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TrustedCertificateImpl(TrustedCertificateBuilder base) {
            super(base.augmentation, (Key)TrustedCertificateImpl.extractKey(base));
            TrustedCertificateKey key = (TrustedCertificateKey)this.key();
            this._name = key.getName();
            this._certificate = base.getCertificate();
        }

        private static @NonNull TrustedCertificateKey extractKey(TrustedCertificateBuilder base) {
            TrustedCertificateKey key = base.key();
            return key != null ? key : new TrustedCertificateKey(base.getName());
        }

        @Override
        public String getCertificate() {
            return this._certificate;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = TrustedCertificate.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return TrustedCertificate.bindingEquals(this, obj);
        }

        public String toString() {
            return TrustedCertificate.bindingToString(this);
        }
    }
}

