/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.Netconf;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.Streams;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netmod.notification.rev080714.netconf.StreamsBuilder;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractAugmentable;

public class NetconfBuilder {
    private Streams _streams;
    Map<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>> augmentation = Map.of();

    public NetconfBuilder() {
    }

    public NetconfBuilder(Netconf base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>>(aug);
        }
        this._streams = base.getStreams();
    }

    public static @NonNull Netconf empty() {
        return LazyEmpty.INSTANCE;
    }

    public Streams getStreams() {
        return this._streams;
    }

    public <E$$ extends Augmentation<Netconf>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NetconfBuilder setStreams(Streams value) {
        this._streams = value;
        return this;
    }

    public NetconfBuilder addAugmentation(Augmentation<Netconf> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Netconf>>, Augmentation<Netconf>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public NetconfBuilder removeAugmentation(Class<? extends Augmentation<Netconf>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Netconf build() {
        return new NetconfImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Netconf INSTANCE = new NetconfBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class NetconfImpl
    extends AbstractAugmentable<Netconf>
    implements Netconf {
        private final Streams _streams;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NetconfImpl(NetconfBuilder base) {
            super(base.augmentation);
            this._streams = base.getStreams();
        }

        @Override
        public Streams getStreams() {
            return this._streams;
        }

        @Override
        public Streams nonnullStreams() {
            return Objects.requireNonNullElse(this.getStreams(), StreamsBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Netconf.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Netconf.bindingEquals(this, obj);
        }

        public String toString() {
            return Netconf.bindingToString(this);
        }
    }
}

