/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.capability;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.capability.ParameterizedCapability;

public record YangModuleCapability(@NonNull String moduleNamespace, String moduleName, String revision, List<String> features, List<String> deviations, String urn) implements ParameterizedCapability
{
    private static final @NonNull String MODULE_PARAM = "module";
    private static final @NonNull String REVISION_PARAM = "revision";
    private static final @NonNull String FEATURES_PARAM = "features";
    private static final @NonNull String DEVIATIONS_PARAM = "deviations";
    private static final @NonNull Set<String> PARAMETERS = ImmutableSet.of((Object)"module", (Object)"revision", (Object)"features", (Object)"deviations");

    public YangModuleCapability(@NonNull String moduleNamespace, String moduleName, String revision, List<String> features, List<String> deviations) {
        this(Objects.requireNonNull(moduleNamespace), moduleName, revision, features == null || features.isEmpty() ? null : List.copyOf(features), deviations == null || deviations.isEmpty() ? null : List.copyOf(deviations), YangModuleCapability.buildUrn(moduleNamespace, moduleName, revision, features, deviations));
    }

    private static String buildUrn(String moduleNamespace, String moduleName, String revision, List<String> features, List<String> deviations) {
        StringBuilder sb = new StringBuilder().append(moduleNamespace);
        boolean isFirstParam = true;
        if (moduleName != null) {
            sb.append("?").append(MODULE_PARAM).append("=").append(moduleName);
            isFirstParam = false;
        }
        if (revision != null) {
            sb.append(isFirstParam ? "?" : "&");
            sb.append(REVISION_PARAM).append("=").append(revision);
            isFirstParam = false;
        }
        if (features != null && !features.isEmpty()) {
            sb.append(isFirstParam ? "?" : "&");
            sb.append(FEATURES_PARAM).append("=").append(String.join((CharSequence)",", features));
            isFirstParam = false;
        }
        if (deviations != null && !deviations.isEmpty()) {
            sb.append(isFirstParam ? "?" : "&");
            sb.append(DEVIATIONS_PARAM).append("=").append(String.join((CharSequence)",", deviations));
        }
        return sb.toString();
    }

    @Override
    public Set<String> parameterNames() {
        return PARAMETERS;
    }
}

