/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.xml;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.xml.MissingNameSpaceException;
import org.opendaylight.netconf.api.xml.UnexpectedElementException;
import org.opendaylight.netconf.api.xml.UnexpectedNamespaceException;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class XmlElement {
    public static final @NonNull String DEFAULT_NAMESPACE_PREFIX = "";
    private final Element element;

    private XmlElement(Element element) {
        this.element = element;
    }

    public static XmlElement fromDomElement(Element element) {
        return new XmlElement(element);
    }

    public static XmlElement fromDomDocument(Document xml) {
        return new XmlElement(xml.getDocumentElement());
    }

    public static XmlElement fromString(String str) throws DocumentedException {
        try {
            return new XmlElement(XmlUtil.readXmlToElement(str));
        }
        catch (IOException | SAXException e) {
            throw DocumentedException.wrap(e);
        }
    }

    public static XmlElement fromDomElementWithExpected(Element element, String expectedName) throws DocumentedException {
        XmlElement xmlElement = XmlElement.fromDomElement(element);
        xmlElement.checkName(expectedName);
        return xmlElement;
    }

    public static XmlElement fromDomElementWithExpected(Element element, String expectedName, String expectedNamespace) throws DocumentedException {
        XmlElement xmlElement = XmlElement.fromDomElementWithExpected(element, expectedName);
        xmlElement.checkNamespace(expectedNamespace);
        return xmlElement;
    }

    public void checkName(String expectedName) throws UnexpectedElementException {
        if (!this.getName().equals(expectedName)) {
            throw new UnexpectedElementException(String.format("Expected %s xml element but was %s", expectedName, this.getName()), ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
        }
    }

    public void checkNamespaceAttribute(String expectedNamespace) throws UnexpectedNamespaceException, MissingNameSpaceException {
        if (!this.getNamespaceAttribute().equals(expectedNamespace)) {
            throw new UnexpectedNamespaceException(String.format("Unexpected namespace %s should be %s", this.getNamespaceAttribute(), expectedNamespace), ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
        }
    }

    public void checkNamespace(String expectedNamespace) throws UnexpectedNamespaceException, MissingNameSpaceException {
        if (!this.getNamespace().equals(expectedNamespace)) {
            throw new UnexpectedNamespaceException(String.format("Unexpected namespace %s should be %s", this.getNamespace(), expectedNamespace), ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
        }
    }

    public String getName() {
        String localName = this.element.getLocalName();
        return Strings.isNullOrEmpty((String)localName) ? this.element.getTagName() : localName;
    }

    public String getAttribute(String attributeName) {
        return this.element.getAttribute(attributeName);
    }

    public String getAttribute(String attributeName, String namespace) {
        return this.element.getAttributeNS(namespace, attributeName);
    }

    public NodeList getElementsByTagName(String name) {
        return this.element.getElementsByTagName(name);
    }

    public void appendChild(Element toAppend) {
        this.element.appendChild(toAppend);
    }

    public Element getDomElement() {
        return this.element;
    }

    public Map<String, Attr> getAttributes() {
        NamedNodeMap attributes = this.element.getAttributes();
        HashMap<String, Attr> result = new HashMap<String, Attr>();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = attributes.item(i);
            if (!(node instanceof Attr)) continue;
            Attr attr = (Attr)node;
            result.put(attr.getNodeName(), attr);
        }
        return result;
    }

    private List<XmlElement> getChildElementsInternal(Predicate<@NonNull Element> strat) {
        NodeList childNodes = this.element.getChildNodes();
        ArrayList<XmlElement> result = new ArrayList<XmlElement>();
        int length = childNodes.getLength();
        for (int i = 0; i < length; ++i) {
            Element elem;
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !strat.test(elem = (Element)node)) continue;
            result.add(new XmlElement(elem));
        }
        return result;
    }

    public List<XmlElement> getChildElements() {
        return this.getChildElementsInternal(e -> true);
    }

    public List<XmlElement> getChildElements(String tagName) {
        return this.getChildElementsInternal(e -> e.getLocalName().equals(tagName));
    }

    public List<XmlElement> getChildElementsWithinNamespace(String childName, String namespace) {
        return this.getChildElementsWithinNamespace(namespace).stream().filter(xmlElement -> xmlElement.getName().equals(childName)).collect(Collectors.toList());
    }

    public List<XmlElement> getChildElementsWithinNamespace(String namespace) {
        return this.getChildElementsInternal(e -> {
            String elementNamespace = XmlUtil.namespace(e);
            return elementNamespace != null && elementNamespace.equals(namespace);
        });
    }

    public Optional<XmlElement> getOnlyChildElementOptionally(String childName) {
        List<XmlElement> children = this.getChildElements(childName);
        return children.size() != 1 ? Optional.empty() : Optional.of(children.get(0));
    }

    public Optional<XmlElement> getOnlyChildElementOptionally(String childName, String namespace) {
        List children = this.getChildElementsWithinNamespace(namespace).stream().filter(xmlElement -> xmlElement.getName().equals(childName)).collect(Collectors.toList());
        return children.size() != 1 ? Optional.empty() : Optional.of((XmlElement)children.get(0));
    }

    public Optional<XmlElement> getOnlyChildElementOptionally() {
        List<XmlElement> children = this.getChildElements();
        return children.size() != 1 ? Optional.empty() : Optional.of(children.get(0));
    }

    public XmlElement getOnlyChildElementWithSameNamespace(String childName) throws DocumentedException {
        return this.getOnlyChildElement(childName, this.getNamespace());
    }

    public XmlElement getOnlyChildElementWithSameNamespace() throws DocumentedException {
        XmlElement childElement = this.getOnlyChildElement();
        childElement.checkNamespace(this.getNamespace());
        return childElement;
    }

    public Optional<XmlElement> getOnlyChildElementWithSameNamespaceOptionally(String childName) {
        String namespace = this.namespace();
        if (namespace == null) {
            return Optional.empty();
        }
        List children = this.getChildElementsWithinNamespace(namespace).stream().filter(xmlElement -> xmlElement.getName().equals(childName)).collect(Collectors.toList());
        return children.size() != 1 ? Optional.empty() : Optional.of((XmlElement)children.get(0));
    }

    public Optional<XmlElement> getOnlyChildElementWithSameNamespaceOptionally() {
        String namespace;
        Optional<XmlElement> optChild = this.getOnlyChildElementOptionally();
        if (optChild.isPresent() && (namespace = this.namespace()) != null && namespace.equals(optChild.orElseThrow().namespace())) {
            return optChild;
        }
        return Optional.empty();
    }

    public XmlElement getOnlyChildElement(String childName, String namespace) throws DocumentedException {
        return new XmlElement(XmlUtil.requireSingleElement(this.element, namespace, childName));
    }

    public XmlElement getOnlyChildElement(String childName) throws DocumentedException {
        List<XmlElement> children = this.getChildElements(childName);
        if (children.size() != 1) {
            throw new DocumentedException("One element " + childName + " expected in " + this.toString(), ErrorType.APPLICATION, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
        }
        return children.get(0);
    }

    public XmlElement getOnlyChildElement() throws DocumentedException {
        List<XmlElement> children = this.getChildElements();
        if (children.size() != 1) {
            throw new DocumentedException(String.format("One element expected in %s but was %s", this.toString(), children.size()), ErrorType.APPLICATION, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
        }
        return children.get(0);
    }

    public @NonNull String getTextContent() throws DocumentedException {
        NodeList children = this.element.getChildNodes();
        int length = children.getLength();
        if (length == 0) {
            return DEFAULT_NAMESPACE_PREFIX;
        }
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            if (!(node instanceof Text)) continue;
            Text textChild = (Text)node;
            return textChild.getTextContent().trim();
        }
        throw new DocumentedException(this.getName() + " should contain text", ErrorType.APPLICATION, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
    }

    public Optional<String> getOnlyTextContentOptionally() {
        Node node;
        NodeList children = this.element.getChildNodes();
        if (children.getLength() == 1 && (node = children.item(0)) instanceof Text) {
            Text textChild = (Text)node;
            return Optional.of(textChild.getWholeText());
        }
        return Optional.empty();
    }

    @VisibleForTesting
    @NonNull String getNamespaceAttribute() throws MissingNameSpaceException {
        String attribute = XmlUtil.namespaceAttribute(this.element);
        if (attribute == null) {
            throw new MissingNameSpaceException("Element " + String.valueOf(this) + " must specify namespace", ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
        }
        return attribute;
    }

    public @Nullable String namespace() {
        return XmlUtil.namespace(this.element);
    }

    public @NonNull String getNamespace() throws MissingNameSpaceException {
        String namespace = this.namespace();
        if (namespace == null) {
            throw new MissingNameSpaceException("No namespace defined for " + String.valueOf(this), ErrorType.APPLICATION, ErrorTag.OPERATION_FAILED, ErrorSeverity.ERROR);
        }
        return namespace;
    }

    public Map.Entry<String, String> findNamespaceOfTextContent() throws DocumentedException {
        String textContent = this.getTextContent();
        int firstColon = textContent.indexOf(58);
        String textPrefix = firstColon == -1 ? DEFAULT_NAMESPACE_PREFIX : textContent.substring(0, firstColon);
        Map<String, String> namespaces = this.extractNamespaces();
        if (!namespaces.containsKey(textPrefix)) {
            throw new IllegalArgumentException("Cannot find namespace for " + XmlUtil.toString(this.element) + ". Prefix from content is " + textPrefix + ". Found namespaces " + String.valueOf(namespaces));
        }
        return new AbstractMap.SimpleImmutableEntry<String, String>(textPrefix, namespaces.get(textPrefix));
    }

    private Map<String, String> extractNamespaces() throws DocumentedException {
        String namespace;
        HashMap<String, String> namespaces = new HashMap<String, String>();
        NamedNodeMap attributes = this.element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            String prefix;
            Node attribute = attributes.item(i);
            String attribKey = attribute.getNodeName();
            if (!attribKey.startsWith("xmlns")) continue;
            if (attribKey.equals("xmlns")) {
                prefix = DEFAULT_NAMESPACE_PREFIX;
            } else if (attribKey.startsWith("xmlns:")) {
                prefix = attribKey.substring("xmlns".length() + 1);
            } else {
                throw new DocumentedException("Attribute does not start with :", ErrorType.APPLICATION, ErrorTag.INVALID_VALUE, ErrorSeverity.ERROR);
            }
            namespaces.put(prefix, attribute.getNodeValue());
        }
        if (!namespaces.containsKey(DEFAULT_NAMESPACE_PREFIX) && (namespace = this.namespace()) != null) {
            namespaces.put(DEFAULT_NAMESPACE_PREFIX, namespace);
        }
        return namespaces;
    }

    boolean hasNamespace() {
        return XmlUtil.hasNamespace(this.element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof XmlElement)) return false;
        XmlElement other = (XmlElement)obj;
        if (!this.element.isEqualNode(other.element)) return false;
        return true;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("XmlElement{").append("name='").append(this.getName()).append('\'');
        String namespace = this.namespace();
        if (namespace != null) {
            sb.append(", namespace='").append(namespace).append('\'');
        }
        return sb.append('}').toString();
    }
}

