/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.capability;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.api.capability.ExiSchemas;
import org.opendaylight.netconf.api.capability.ParameterizedCapability;

public record ExiCapability(Integer compression, ExiSchemas schemas, @NonNull String urn) implements ParameterizedCapability
{
    private static final @NonNull String COMPRESSION_PARAM = "compression";
    private static final @NonNull String SCHEMAS_PARAM = "schemas";
    private static final @NonNull Set<String> PARAMETERS = ImmutableSet.of((Object)"compression", (Object)"schemas");

    public ExiCapability(Integer compression, ExiSchemas schemas) {
        this(compression, schemas, ExiCapability.buildUrn(compression, schemas));
    }

    private static String buildUrn(Integer compression, ExiSchemas schemas) {
        StringBuilder sb = new StringBuilder("urn:ietf:params:netconf:capability:exi:1.0");
        boolean isFirstParam = true;
        if (compression != null) {
            sb.append("?").append(COMPRESSION_PARAM).append("=").append(compression);
            isFirstParam = false;
        }
        if (schemas != null) {
            sb.append(isFirstParam ? "?" : "&");
            sb.append(SCHEMAS_PARAM).append("=").append(schemas.getValue());
        }
        return sb.toString();
    }

    @Override
    public Set<String> parameterNames() {
        return PARAMETERS;
    }
}

