/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.subtree;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.api.subtree.NamespaceSelection;
import org.opendaylight.netconf.api.subtree.Sibling;

@NonNullByDefault
public record ContentMatchNode(NamespaceSelection selection, String value) implements Sibling
{
    public ContentMatchNode {
        Objects.requireNonNull(selection);
        if (value.isEmpty()) {
            throw new IllegalArgumentException("empty value");
        }
        ContentMatchNode.checkNotWhitespace("leading", value.charAt(0));
        ContentMatchNode.checkNotWhitespace("trailing", value.charAt(value.length() - 1));
    }

    private static void checkNotWhitespace(String kind, char ch) {
        if (ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t') {
            throw new IllegalArgumentException("values has " + kind + " whitespace");
        }
    }
}

