/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.subtree;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.api.subtree.ContainmentNode;
import org.opendaylight.netconf.api.subtree.NamespaceSelection;
import org.opendaylight.netconf.api.subtree.Sibling;
import org.opendaylight.netconf.api.subtree.SubtreeFilter;

final class Prefixes {
    private final LinkedHashMap<String, String> namespaceToPrefixMap;

    private Prefixes(@NonNull LinkedHashMap<String, String> namespaceToPrefix) {
        this.namespaceToPrefixMap = Objects.requireNonNull(namespaceToPrefix);
    }

    static Prefixes of(SubtreeFilter filter) {
        TreeSet<String> namespaces = new TreeSet<String>();
        Prefixes.createPrefixes(filter.siblings(), namespaces);
        LinkedHashMap<String, String> prefixes = new LinkedHashMap<String, String>(namespaces.size());
        int counter = 0;
        for (String ns : namespaces) {
            String prefix = Prefixes.prefixOf(counter);
            if (prefix.equals("xml") || prefix.equals("xmlns")) {
                prefix = Prefixes.prefixOf(++counter);
            }
            prefixes.put(ns, prefix);
            ++counter;
        }
        return new Prefixes(prefixes);
    }

    private static void createPrefixes(Collection<Sibling> siblings, TreeSet<String> namespaces) {
        for (Sibling sibling : siblings) {
            NamespaceSelection namespaceSelection = sibling.selection();
            if (!(namespaceSelection instanceof NamespaceSelection.Exact)) continue;
            NamespaceSelection.Exact exact = (NamespaceSelection.Exact)namespaceSelection;
            namespaces.add(exact.namespace());
            if (!(sibling instanceof ContainmentNode)) continue;
            ContainmentNode containment = (ContainmentNode)sibling;
            Prefixes.createPrefixes(containment.siblings(), namespaces);
        }
    }

    static String prefixOf(int index) {
        String prefix = index < 0 ? "" : Prefixes.prefixOf(index / 26 - 1) + (char)(65 + index % 26);
        return prefix.toLowerCase(Locale.ROOT);
    }

    @NonNullByDefault
    String lookUpPrefix(String namespace) {
        String prefix = this.namespaceToPrefixMap.get(Objects.requireNonNull(namespace));
        if (prefix == null) {
            throw new IllegalStateException("No prefix assigned to namespace " + namespace);
        }
        return prefix;
    }

    LinkedHashMap<String, String> getNamespaceToPrefixMap() {
        return this.namespaceToPrefixMap;
    }
}

