/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.subtree;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.subtree.AttributeMatch;
import org.opendaylight.netconf.api.subtree.NamespaceSelection;
import org.opendaylight.netconf.api.subtree.Sibling;

@NonNullByDefault
public final class SelectionNode
implements Sibling {
    private final List<AttributeMatch> attributeMatches;
    private final NamespaceSelection selection;

    private SelectionNode(NamespaceSelection selection, List<AttributeMatch> attributeMatches) {
        this.selection = Objects.requireNonNull(selection);
        this.attributeMatches = Objects.requireNonNull(attributeMatches);
    }

    public static Builder builder(NamespaceSelection selection) {
        return new Builder(selection);
    }

    @Override
    public NamespaceSelection selection() {
        return this.selection;
    }

    public List<AttributeMatch> attributeMatches() {
        return this.attributeMatches;
    }

    public int hashCode() {
        return Objects.hash(this.selection, this.attributeMatches);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SelectionNode)) return false;
        SelectionNode other = (SelectionNode)obj;
        if (!this.selection.equals(other.selection)) return false;
        if (!this.attributeMatches.equals(other.attributeMatches)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("selection", (Object)this.selection).add("attributeMatches", this.attributeMatches).toString();
    }

    public static final class Builder {
        private final ArrayList<AttributeMatch> attributeMatches = new ArrayList();
        private final NamespaceSelection selection;

        private Builder(NamespaceSelection selection) {
            this.selection = Objects.requireNonNull(selection);
        }

        public Builder add(AttributeMatch attributeMatch) {
            this.attributeMatches.add(Objects.requireNonNull(attributeMatch));
            return this;
        }

        public SelectionNode build() {
            return new SelectionNode(this.selection, List.copyOf(this.attributeMatches));
        }
    }
}

