/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.subtree;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.subtree.ContainmentNode;
import org.opendaylight.netconf.api.subtree.NamespaceSelection;
import org.opendaylight.netconf.api.subtree.Sibling;
import org.opendaylight.netconf.api.subtree.SubtreeFilter;

@NonNullByDefault
abstract sealed class SiblingSetBuilder
permits ContainmentNode.Builder, SubtreeFilter.Builder {
    private static final Comparator<Sibling> COMPARATOR = Comparator.comparing(NamespaceName::of);
    private final ArrayList<Sibling> siblings = new ArrayList();

    SiblingSetBuilder() {
    }

    final void addSibling(Sibling sibling) {
        this.siblings.add(Objects.requireNonNull(sibling));
    }

    final <S extends Sibling> List<S> siblings(Class<S> filter) {
        return this.siblings.stream().filter(filter::isInstance).map(filter::cast).distinct().sorted(COMPARATOR).collect(Collectors.toUnmodifiableList());
    }

    private record NamespaceName(String name, @Nullable String namespace) implements Comparable<NamespaceName>
    {
        NamespaceName(String name, @Nullable String namespace) {
            Objects.requireNonNull(name);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static NamespaceName of(Sibling sibling) {
            NamespaceName namespaceName;
            NamespaceSelection namespaceSelection = sibling.selection();
            Objects.requireNonNull(namespaceSelection);
            NamespaceSelection namespaceSelection2 = namespaceSelection;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NamespaceSelection.Exact.class, NamespaceSelection.Wildcard.class}, (Object)namespaceSelection2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    NamespaceSelection.Exact exact = (NamespaceSelection.Exact)namespaceSelection2;
                    try {
                        String string;
                        String namespace = string = exact.namespace();
                        String name = string = exact.name();
                        namespaceName = new NamespaceName(name, namespace);
                        return namespaceName;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: 
            }
            NamespaceSelection.Wildcard wildcard = (NamespaceSelection.Wildcard)namespaceSelection2;
            {
                String string;
                String name = string = wildcard.name();
                namespaceName = new NamespaceName(name, null);
            }
            return namespaceName;
        }

        @Override
        public int compareTo(NamespaceName other) {
            int cmp = this.name.compareTo(other.name);
            if (cmp != 0) {
                return cmp;
            }
            String tns = this.namespace;
            String ons = other.namespace;
            if (tns == null) {
                return ons == null ? 0 : -1;
            }
            return ons == null ? 1 : tns.compareTo(ons);
        }
    }
}

