/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.subtree;

import com.google.common.base.MoreObjects;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.subtree.AttributeMatch;
import org.opendaylight.netconf.api.subtree.ContainmentNode;
import org.opendaylight.netconf.api.subtree.ContentMatchNode;
import org.opendaylight.netconf.api.subtree.NamespaceSelection;
import org.opendaylight.netconf.api.subtree.Prefixes;
import org.opendaylight.netconf.api.subtree.SelectionNode;
import org.opendaylight.netconf.api.subtree.Sibling;
import org.opendaylight.netconf.api.subtree.SiblingSet;
import org.opendaylight.netconf.api.subtree.SiblingSetBuilder;
import org.opendaylight.netconf.api.subtree.SubtreeFilterPrettyTree;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.PrettyTree;
import org.opendaylight.yangtools.concepts.PrettyTreeAware;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@NonNullByDefault
public final class SubtreeFilter
implements Immutable,
SiblingSet,
PrettyTreeAware {
    private final List<ContentMatchNode> contentMatches;
    private final List<ContainmentNode> containments;
    private final List<SelectionNode> selections;

    private SubtreeFilter(Builder builder) {
        this.contentMatches = builder.siblings(ContentMatchNode.class);
        this.containments = builder.siblings(ContainmentNode.class);
        this.selections = builder.siblings(SelectionNode.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SubtreeFilter readFrom(Element element) {
        XmlElement filter = XmlElement.fromDomElement(element);
        Builder subtreeFilterBuilder = new Builder();
        for (XmlElement xml : filter.getChildElements()) {
            Element domXml = xml.getDomElement();
            if (xml.getChildElements().isEmpty()) {
                String content = domXml.getTextContent();
                if (content.isEmpty()) {
                    subtreeFilterBuilder.add(SubtreeFilter.fillSelection(domXml));
                    continue;
                }
                subtreeFilterBuilder.add(new ContentMatchNode(SubtreeFilter.getNamespaceSelection(domXml), content));
                continue;
            }
            ContainmentNode.Builder containment = ContainmentNode.builder(SubtreeFilter.getNamespaceSelection(domXml));
            subtreeFilterBuilder.add(SubtreeFilter.fillContainment(domXml, containment).build());
        }
        return subtreeFilterBuilder.build();
    }

    private static NamespaceSelection getNamespaceSelection(Node node) {
        if (node.getNamespaceURI() != null) {
            return new NamespaceSelection.Exact(node.getNamespaceURI(), node.getLocalName());
        }
        return new NamespaceSelection.Wildcard(node.getLocalName());
    }

    private static ContainmentNode.Builder fillContainment(Element element, ContainmentNode.Builder builder) {
        XmlElement xml = XmlElement.fromDomElement(element);
        for (XmlElement child : xml.getChildElements()) {
            Element domChild = child.getDomElement();
            if (child.getChildElements().isEmpty()) {
                String content = domChild.getTextContent();
                if (content.isEmpty()) {
                    builder.add(SubtreeFilter.fillSelection(child.getDomElement()));
                    continue;
                }
                builder.add(new ContentMatchNode(SubtreeFilter.getNamespaceSelection(domChild), content)).build();
                continue;
            }
            builder.add(SubtreeFilter.fillContainment(domChild, ContainmentNode.builder(SubtreeFilter.getNamespaceSelection(domChild))).build()).build();
        }
        return builder;
    }

    private static SelectionNode fillSelection(Element element) {
        SelectionNode.Builder selection = SelectionNode.builder(SubtreeFilter.getNamespaceSelection(element));
        List<AttributeMatch> attributeMatches = SubtreeFilter.collectAttributes(element);
        for (AttributeMatch attribute : attributeMatches) {
            selection.add(attribute);
        }
        return selection.build();
    }

    private static List<AttributeMatch> collectAttributes(Element element) {
        ArrayList<AttributeMatch> attributeMatches = new ArrayList<AttributeMatch>();
        if (element.hasAttributes()) {
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                String attrNamespace = attribute.getNamespaceURI();
                if ("http://www.w3.org/2000/xmlns/".equals(attrNamespace)) continue;
                if (attrNamespace == null || attrNamespace.isEmpty()) {
                    throw new IllegalArgumentException("Attribute has no namespace");
                }
                attributeMatches.add(new AttributeMatch(new NamespaceSelection.Exact(attribute.getNamespaceURI(), attribute.getLocalName()), attribute.getNodeValue()));
            }
        }
        return attributeMatches;
    }

    public void writeTo(Element element) {
        Document doc = element.getOwnerDocument();
        XmlElement xml = XmlElement.fromDomElement(element);
        Prefixes prefixes = Prefixes.of(this);
        this.writeSiblings(doc, xml, prefixes, this);
    }

    private void writeSiblings(Document doc, XmlElement xml, Prefixes prefixes, SiblingSet siblings) {
        Element child;
        for (ContentMatchNode contentMatch : siblings.contentMatches()) {
            child = SubtreeFilter.writeSibling(contentMatch, doc, prefixes);
            child.setTextContent(contentMatch.value());
            xml.appendChild(child);
        }
        for (SelectionNode selection : siblings.selections()) {
            child = SubtreeFilter.writeSibling(selection, doc, prefixes);
            for (AttributeMatch attr : selection.attributeMatches()) {
                child.setAttributeNS(attr.selection().namespace(), attr.selection().name(), attr.value());
            }
            xml.appendChild(child);
        }
        for (ContainmentNode containment : siblings.containments()) {
            child = SubtreeFilter.writeSibling(containment, doc, prefixes);
            this.writeSiblings(doc, XmlElement.fromDomElement(child), prefixes, containment);
            xml.appendChild(child);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Element writeSibling(Sibling sibling, Document doc, Prefixes prefixes) {
        String name;
        NamespaceSelection namespaceSelection = sibling.selection();
        Objects.requireNonNull(namespaceSelection);
        NamespaceSelection namespaceSelection2 = namespaceSelection;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NamespaceSelection.Exact.class, NamespaceSelection.Wildcard.class}, (Object)namespaceSelection2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String name2;
                String namespace;
                NamespaceSelection.Exact exact = (NamespaceSelection.Exact)namespaceSelection2;
                try {
                    String string;
                    namespace = string = exact.namespace();
                    name2 = string = exact.name();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Element child = doc.createElementNS(namespace, name2);
                child.setPrefix(prefixes.lookUpPrefix(namespace));
                return child;
            }
            case 1: 
        }
        NamespaceSelection.Wildcard wildcard = (NamespaceSelection.Wildcard)namespaceSelection2;
        {
            String string;
            name = string = wildcard.name();
        }
        return doc.createElement(name);
    }

    @Override
    public List<ContentMatchNode> contentMatches() {
        return this.contentMatches;
    }

    @Override
    public List<ContainmentNode> containments() {
        return this.containments;
    }

    @Override
    public List<SelectionNode> selections() {
        return this.selections;
    }

    public PrettyTree prettyTree() {
        return new SubtreeFilterPrettyTree(this);
    }

    public int hashCode() {
        return Objects.hash(this.contentMatches, this.containments, this.selections);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SubtreeFilter)) return false;
        SubtreeFilter other = (SubtreeFilter)obj;
        if (!this.contentMatches.equals(other.contentMatches)) return false;
        if (!this.containments.equals(other.containments)) return false;
        if (!this.selections.equals(other.selections)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("siblings", (Object)this.siblings()).toString();
    }

    public static final class Builder
    extends SiblingSetBuilder {
        private Builder() {
        }

        public Builder add(Sibling sibling) {
            this.addSibling(sibling);
            return this;
        }

        public SubtreeFilter build() {
            return new SubtreeFilter(this);
        }
    }
}

