/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.subtree;

import com.google.common.xml.XmlEscapers;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.netconf.api.subtree.AttributeMatch;
import org.opendaylight.netconf.api.subtree.ContainmentNode;
import org.opendaylight.netconf.api.subtree.ContentMatchNode;
import org.opendaylight.netconf.api.subtree.NamespaceSelection;
import org.opendaylight.netconf.api.subtree.Prefixes;
import org.opendaylight.netconf.api.subtree.SelectionNode;
import org.opendaylight.netconf.api.subtree.Sibling;
import org.opendaylight.netconf.api.subtree.SiblingSet;
import org.opendaylight.netconf.api.subtree.SubtreeFilter;
import org.opendaylight.yangtools.concepts.PrettyTree;

final class SubtreeFilterPrettyTree
extends PrettyTree {
    private final SubtreeFilter filter;
    private final Prefixes prefixes;

    SubtreeFilterPrettyTree(SubtreeFilter filter) {
        this.filter = Objects.requireNonNull(filter);
        this.prefixes = Prefixes.of(filter);
    }

    public void appendTo(StringBuilder sb, int depth) {
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb, (int)depth);
        sb.append("<filter type=\"subtree\">");
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb.append('\n'), (int)depth);
        SubtreeFilterPrettyTree.appendSiblingSet(sb, depth + 1, this.prefixes, this.filter);
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb, (int)depth);
        sb.append("</filter>");
    }

    private static void appendContainment(StringBuilder sb, int depth, Prefixes prefixes, ContainmentNode node) {
        SubtreeFilterPrettyTree.startSibling(sb, depth, prefixes, node);
        sb.append(">\n");
        SubtreeFilterPrettyTree.appendSiblingSet(sb, depth + 1, prefixes, node);
        SubtreeFilterPrettyTree.endSibling(sb, depth, prefixes, node);
    }

    private static void appendContentMatch(StringBuilder sb, int depth, Prefixes prefixes, ContentMatchNode node) {
        SubtreeFilterPrettyTree.startSibling(sb, depth, prefixes, node);
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb.append(">\n"), (int)(depth + 1));
        sb.append(XmlEscapers.xmlContentEscaper().escape(node.value())).append('\n');
        SubtreeFilterPrettyTree.endSibling(sb, depth, prefixes, node);
    }

    private static void appendSelection(StringBuilder sb, int depth, Prefixes prefixes, SelectionNode node) {
        SubtreeFilterPrettyTree.startSibling(sb, depth, prefixes, node);
        for (AttributeMatch am : node.attributeMatches()) {
            NamespaceSelection.Exact selection = am.selection();
            SubtreeFilterPrettyTree.appendPrefix(sb.append(' '), prefixes, selection.namespace());
            SubtreeFilterPrettyTree.appendAttributeData(sb.append(selection.name()).append('='), am.value());
        }
        sb.append("/>\n");
    }

    private static void appendSiblingSet(StringBuilder sb, int depth, Prefixes prefixes, SiblingSet siblings) {
        for (ContentMatchNode contentMatch : siblings.contentMatches()) {
            SubtreeFilterPrettyTree.appendContentMatch(sb, depth, prefixes, contentMatch);
        }
        for (SelectionNode selection : siblings.selections()) {
            SubtreeFilterPrettyTree.appendSelection(sb, depth, prefixes, selection);
        }
        for (ContainmentNode containment : siblings.containments()) {
            SubtreeFilterPrettyTree.appendContainment(sb, depth, prefixes, containment);
        }
    }

    private static void startSibling(StringBuilder sb, int depth, Prefixes prefixes, Sibling node) {
        LinkedHashMap<String, String> prefixesMap;
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb, (int)depth);
        SubtreeFilterPrettyTree.appendNamespaceSelection(sb.append('<'), prefixes, node);
        if (depth == 1 && !(prefixesMap = prefixes.getNamespaceToPrefixMap()).isEmpty()) {
            Iterator<Map.Entry<String, String>> prefixesIt = prefixesMap.entrySet().iterator();
            Map.Entry<String, String> entry = prefixesIt.next();
            SubtreeFilterPrettyTree.appendAttributeData(sb.append(" xmlns:").append(entry.getValue()).append('='), entry.getKey());
            while (prefixesIt.hasNext()) {
                entry = prefixesIt.next();
                SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb.append('\n'), (int)depth);
                SubtreeFilterPrettyTree.appendAttributeData(sb.append(" xmlns:").append(entry.getValue()).append('='), entry.getKey());
            }
        }
    }

    private static void endSibling(StringBuilder sb, int depth, Prefixes prefixes, Sibling node) {
        SubtreeFilterPrettyTree.appendIndent((StringBuilder)sb, (int)depth);
        SubtreeFilterPrettyTree.appendNamespaceSelection(sb.append("</"), prefixes, node);
        sb.append(">\n");
    }

    private static void appendNamespaceSelection(StringBuilder sb, Prefixes prefixes, Sibling node) {
        NamespaceSelection namespaceSelection = node.selection();
        Objects.requireNonNull(namespaceSelection);
        NamespaceSelection namespaceSelection2 = namespaceSelection;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NamespaceSelection.Exact.class, NamespaceSelection.Wildcard.class}, (Object)namespaceSelection2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String string;
                NamespaceSelection.Exact exact = (NamespaceSelection.Exact)namespaceSelection2;
                String namespace = string = exact.namespace();
                String name = string = exact.name();
                SubtreeFilterPrettyTree.appendPrefix(sb, prefixes, namespace);
                sb.append(name);
                break;
            }
            case 1: {
                NamespaceSelection.Wildcard wildcard = (NamespaceSelection.Wildcard)namespaceSelection2;
                try {
                    String string;
                    String name = string = wildcard.name();
                    sb.append(name);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                break;
            }
        }
    }

    private static void appendPrefix(StringBuilder sb, Prefixes prefixes, String namespace) {
        sb.append(prefixes.lookUpPrefix(namespace)).append(':');
    }

    private static void appendAttributeData(StringBuilder sb, String str) {
        sb.append('\"').append(XmlEscapers.xmlAttributeEscaper().escape(str)).append('\"');
    }
}

