/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.xml;

import com.google.common.base.MoreObjects;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

record ImmutableNamespaceContext(ImmutableListMultimap<String, String> uriToPrefix, ImmutableBiMap<String, String> prefixToUri) implements NamespaceContext
{
    private static final ImmutableBiMap<String, String> FIXED_PREFIX_TO_URI = ImmutableBiMap.of((Object)"xml", (Object)"http://www.w3.org/XML/1998/namespace", (Object)"xmlns", (Object)"http://www.w3.org/2000/xmlns/");
    static final ImmutableNamespaceContext EMPTY = ImmutableNamespaceContext.of(Map.of());

    static ImmutableNamespaceContext of(Map<String, String> prefixToUri) {
        ImmutableListMultimap.Builder uriToPrefixBuilder = ImmutableListMultimap.builder();
        HashBiMap prefixToUriBuilder = HashBiMap.create();
        prefixToUriBuilder.putAll(FIXED_PREFIX_TO_URI);
        uriToPrefixBuilder.putAll((Iterable)FIXED_PREFIX_TO_URI.inverse().entrySet());
        String defaultURI = prefixToUri.get("");
        if (defaultURI != null) {
            ImmutableNamespaceContext.checkMapping("", defaultURI);
            uriToPrefixBuilder.put((Object)defaultURI, (Object)"");
            prefixToUriBuilder.putIfAbsent((Object)"", (Object)defaultURI);
        }
        for (Map.Entry<String, String> entry : prefixToUri.entrySet()) {
            String prefix = Objects.requireNonNull(entry.getKey());
            if (prefix.isEmpty()) continue;
            String namespaceURI = Objects.requireNonNull(entry.getValue());
            ImmutableNamespaceContext.checkMapping(prefix, namespaceURI);
            uriToPrefixBuilder.put((Object)namespaceURI, (Object)prefix);
            prefixToUriBuilder.putIfAbsent((Object)prefix, (Object)namespaceURI);
        }
        return new ImmutableNamespaceContext((ImmutableListMultimap<String, String>)uriToPrefixBuilder.build(), (ImmutableBiMap<String, String>)ImmutableBiMap.copyOf((Map)prefixToUriBuilder));
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return ImmutableNamespaceContext.getValue(this.prefixToUri, prefix, "");
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return ImmutableNamespaceContext.getValue((ImmutableBiMap<String, String>)this.prefixToUri.inverse(), namespaceURI, null);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return this.uriToPrefix.get((Object)ImmutableNamespaceContext.rejectNull(namespaceURI)).iterator();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("prefixToUri", this.prefixToUri).toString();
    }

    private static void checkMapping(String prefix, String namespaceURI) {
        if (namespaceURI.isEmpty()) {
            throw new IllegalArgumentException("Namespace must not be empty (%s)".formatted(prefix));
        }
        String pref = (String)FIXED_PREFIX_TO_URI.get((Object)prefix);
        if (pref != null) {
            throw new IllegalArgumentException("Cannot rebind prefix %s from %s to %s".formatted(prefix, pref, namespaceURI));
        }
        if (FIXED_PREFIX_TO_URI.containsValue((Object)namespaceURI)) {
            throw new IllegalArgumentException("Cannot bind namespace %s".formatted(namespaceURI));
        }
    }

    private static String getValue(ImmutableBiMap<String, String> map, String key, String defaultValue) {
        String found = (String)map.get((Object)ImmutableNamespaceContext.rejectNull(key));
        return found != null ? found : defaultValue;
    }

    private static @NonNull String rejectNull(@Nullable String str) {
        if (str == null) {
            throw new IllegalArgumentException();
        }
        return str;
    }
}

