/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.xml;

import com.google.common.base.MoreObjects;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.api.xml.DefaultNamespaceSetter;
import org.opendaylight.netconf.api.xml.FallbackNamespaceSetter;
import org.opendaylight.netconf.api.xml.XMLSupport;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
abstract sealed class NamespaceSetter
permits DefaultNamespaceSetter, FallbackNamespaceSetter {
    private static final Logger LOG = LoggerFactory.getLogger(NamespaceSetter.class);

    NamespaceSetter() {
    }

    abstract void initializeNamespace(XMLStreamWriter var1) throws XMLStreamException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NamespaceSetter forFactory(XMLOutputFactory xmlFactory, String prefix, String uri) throws XMLStreamException {
        NamespaceContext namespaceContext = XMLSupport.namespaceContextOf(Map.of(prefix, uri));
        try (XMLStreamWriter writer = xmlFactory.createXMLStreamWriter(new DOMResult(XmlUtil.newDocument()));){
            writer.setNamespaceContext(namespaceContext);
        }
        return new DefaultNamespaceSetter(namespaceContext);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    abstract MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper var1);
}

