/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.api.xml;

import com.google.common.annotations.Beta;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.netconf.api.xml.ImmutableNamespaceContext;
import org.opendaylight.netconf.api.xml.NamespaceSetter;

@NonNullByDefault
public final class XMLSupport {
    private static final String RFC4741_PREFIX = "xc";
    private static final XMLOutputFactory XML_FACTORY;
    private static final NamespaceSetter XML_NAMESPACE_SETTER;

    private XMLSupport() {
    }

    public static XMLStreamWriter newStreamWriter(Result result) throws XMLStreamException {
        return XML_FACTORY.createXMLStreamWriter(result);
    }

    public static XMLStreamWriter newNetconfStreamWriter(Result result) throws XMLStreamException {
        XMLStreamWriter writer = XMLSupport.newStreamWriter(result);
        XML_NAMESPACE_SETTER.initializeNamespace(writer);
        return writer;
    }

    @Beta
    public static NamespaceContext namespaceContextOf(Map<String, String> prefixToUri) {
        return prefixToUri.isEmpty() ? ImmutableNamespaceContext.EMPTY : ImmutableNamespaceContext.of(prefixToUri);
    }

    static {
        XMLOutputFactory factory = XMLOutputFactory.newFactory();
        factory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
        try {
            XML_NAMESPACE_SETTER = NamespaceSetter.forFactory(factory, RFC4741_PREFIX, "urn:ietf:params:xml:ns:netconf:base:1.0");
        }
        catch (XMLStreamException e) {
            throw new ExceptionInInitializerError(e);
        }
        XML_FACTORY = factory;
    }
}

