/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.inject.Singleton;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.client.mdsal.api.ActionTransformer;
import org.opendaylight.netconf.client.mdsal.api.DeviceActionFactory;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true, property={"type=default"})
public class DeviceActionFactoryImpl
implements DeviceActionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceActionFactoryImpl.class);

    @Override
    public RemoteDeviceServices.Actions.Normalized createDeviceAction(ActionTransformer messageTransformer, RemoteDeviceCommunicator listener) {
        return (schemaPath, dataTreeIdentifier, input) -> {
            Objects.requireNonNull(schemaPath);
            Objects.requireNonNull(dataTreeIdentifier);
            Objects.requireNonNull(input);
            ListenableFuture<RpcResult<NetconfMessage>> actionResultFuture = listener.sendRequest(messageTransformer.toActionRequest(schemaPath, dataTreeIdentifier, (NormalizedNode)input));
            return Futures.transform(actionResultFuture, netconfMessageRpcResult -> {
                if (netconfMessageRpcResult != null) {
                    return messageTransformer.toActionResult(schemaPath, (NetconfMessage)netconfMessageRpcResult.getResult());
                }
                String message = "Missing action result of action on schema path: " + String.valueOf(schemaPath);
                LOG.error(message);
                throw new IllegalStateException(message);
            }, (Executor)MoreExecutors.directExecutor());
        };
    }
}

