/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.client.mdsal.NetconfMountPointContextFactory;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.rfc8528.model.api.SchemaMountConstants;
import org.opendaylight.yangtools.yang.common.MountPointLabel;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContextFactory;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DeviceMountPointContext
implements Immutable,
MountPointContext {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceMountPointContext.class);
    private static final YangInstanceIdentifier.NodeIdentifier MOUNT_POINT = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"mount-point").intern());
    private static final YangInstanceIdentifier.NodeIdentifier CONFIG = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"config").intern());
    private static final YangInstanceIdentifier.NodeIdentifier MODULE = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"module").intern());
    private static final YangInstanceIdentifier.NodeIdentifier LABEL = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"label").intern());
    private static final YangInstanceIdentifier.NodeIdentifier SCHEMA_REF = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"schema-ref").intern());
    private static final YangInstanceIdentifier.NodeIdentifier INLINE = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"inline").intern());
    private static final YangInstanceIdentifier.NodeIdentifier SHARED_SCHEMA = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"shared-schema").intern());
    private static final YangInstanceIdentifier.NodeIdentifier PARENT_REFERENCE = YangInstanceIdentifier.NodeIdentifier.create((QName)QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"parent-reference").intern());
    private final ImmutableMap<MountPointLabel, NetconfMountPointContextFactory> mountPoints;
    private final @NonNull EffectiveModelContext modelContext;

    private DeviceMountPointContext(EffectiveModelContext modelContext, Map<MountPointLabel, NetconfMountPointContextFactory> mountPoints) {
        this.modelContext = Objects.requireNonNull(modelContext);
        this.mountPoints = ImmutableMap.copyOf(mountPoints);
    }

    static MountPointContext create(MountPointContext emptyContext, ContainerNode mountData) {
        Optional optMountPoint = mountData.findChildByArg((YangInstanceIdentifier.PathArgument)MOUNT_POINT);
        if (optMountPoint.isEmpty()) {
            LOG.debug("mount-point list not present in {}", (Object)mountData);
            return emptyContext;
        }
        EffectiveModelContext schemaContext = emptyContext.modelContext();
        DataContainerChild mountPoint = (DataContainerChild)optMountPoint.orElseThrow();
        Preconditions.checkArgument((boolean)(mountPoint instanceof MapNode), (String)"mount-point list %s is not a MapNode", (Object)mountPoint);
        HashMap<MountPointLabel, NetconfMountPointContextFactory> mountPoints = new HashMap<MountPointLabel, NetconfMountPointContextFactory>();
        for (MapEntryNode entry : ((MapNode)mountPoint).body()) {
            String moduleName = entry.findChildByArg((YangInstanceIdentifier.PathArgument)MODULE).map(mod -> {
                Preconditions.checkArgument((boolean)(mod instanceof LeafNode), (String)"Unexpected module leaf %s", (Object)mod);
                Object value = mod.body();
                Preconditions.checkArgument((boolean)(value instanceof String), (String)"Unexpected module leaf value %s", (Object)value);
                return (String)value;
            }).orElseThrow(() -> new IllegalArgumentException("Mount module missing in " + String.valueOf(entry)));
            Iterator it = schemaContext.findModules(moduleName).iterator();
            Preconditions.checkArgument((boolean)it.hasNext(), (String)"Failed to find a module named %s", (Object)moduleName);
            QNameModule module = ((Module)it.next()).getQNameModule();
            MountPointLabel mountId = new MountPointLabel(QName.create((QNameModule)module, (String)entry.findChildByArg((YangInstanceIdentifier.PathArgument)LABEL).map(lbl -> {
                Preconditions.checkArgument((boolean)(lbl instanceof LeafNode), (String)"Unexpected label leaf %s", (Object)lbl);
                Object value = lbl.body();
                Preconditions.checkArgument((boolean)(value instanceof String), (String)"Unexpected label leaf value %s", (Object)value);
                return (String)value;
            }).orElseThrow(() -> new IllegalArgumentException("Mount module missing in " + String.valueOf(entry)))));
            DataContainerChild child = (DataContainerChild)entry.findChildByArg((YangInstanceIdentifier.PathArgument)SCHEMA_REF).orElseThrow(() -> new IllegalArgumentException("Missing schema-ref choice in " + String.valueOf(entry)));
            Preconditions.checkArgument((boolean)(child instanceof ChoiceNode), (String)"Unexpected schema-ref choice %s", (Object)child);
            ChoiceNode schemaRef = (ChoiceNode)child;
            Optional maybeShared = schemaRef.findChildByArg((YangInstanceIdentifier.PathArgument)SHARED_SCHEMA);
            if (maybeShared.isEmpty()) {
                LOG.debug("Ignoring non-shared mountpoint entry {}", (Object)entry);
                continue;
            }
            mountPoints.put(mountId, new NetconfMountPointContextFactory(schemaContext));
        }
        return new DeviceMountPointContext(schemaContext, mountPoints);
    }

    public EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    public Optional<MountPointContextFactory> findMountPoint(@NonNull MountPointLabel label) {
        return Optional.ofNullable((MountPointContextFactory)this.mountPoints.get((Object)Objects.requireNonNull(label)));
    }
}

