/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.client.mdsal.api.NetconfRpcService;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Get;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.ModulesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangLibrary;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.module.list.Module;
import org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.runtime.spi.BindingRuntimeHelpers;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.OperationFailedException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizationResult;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonParserStream;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizationResultHolder;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class LibraryModulesSchemas {
    private static final Logger LOG = LoggerFactory.getLogger(LibraryModulesSchemas.class);
    private static final Pattern DATE_PATTERN = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})");
    private static final EffectiveModelContext LIBRARY_CONTEXT = BindingRuntimeHelpers.createEffectiveModel((Class[])new Class[]{YangLibrary.class});
    private static final SchemaInferenceStack.Inference MODULES_STATE_INFERENCE = SchemaInferenceStack.ofDataTreePath((EffectiveModelContext)LIBRARY_CONTEXT, (QName[])new QName[]{ModulesState.QNAME}).toInference();
    private static final YangInstanceIdentifier.NodeIdentifier MODULES_STATE_NID = YangInstanceIdentifier.NodeIdentifier.create((QName)ModulesState.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier MODULE_NID = YangInstanceIdentifier.NodeIdentifier.create((QName)Module.QNAME);
    private static final YangInstanceIdentifier.NodeIdentifier NAME_NID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"name"));
    private static final YangInstanceIdentifier.NodeIdentifier REVISION_NID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"revision"));
    private static final YangInstanceIdentifier.NodeIdentifier SCHEMA_NID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"schema"));
    private static final YangInstanceIdentifier.NodeIdentifier NAMESPACE_NID = YangInstanceIdentifier.NodeIdentifier.create((QName)YangModuleInfoImpl.qnameOf((String)"namespace"));
    private static final JSONCodecFactory JSON_CODECS = JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(LIBRARY_CONTEXT);
    private static final YangInstanceIdentifier MODULES_STATE_MODULE_LIST = YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{MODULES_STATE_NID, MODULE_NID});
    private static final @NonNull ContainerNode GET_MODULES_STATE_MODULE_LIST_RPC = (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_GET_NODEID).withChild(NetconfMessageTransformUtil.toFilterStructure(MODULES_STATE_MODULE_LIST, LIBRARY_CONTEXT)).build();
    private static final @NonNull LibraryModulesSchemas EMPTY = new LibraryModulesSchemas((ImmutableMap<QName, URL>)ImmutableMap.of());
    private final ImmutableMap<QName, URL> availableModels;

    private LibraryModulesSchemas(ImmutableMap<QName, URL> availableModels) {
        this.availableModels = Objects.requireNonNull(availableModels);
    }

    public static ListenableFuture<LibraryModulesSchemas> forDevice(NetconfRpcService deviceRpc, final RemoteDeviceId deviceId) {
        final SettableFuture future = SettableFuture.create();
        Futures.addCallback(deviceRpc.invokeNetconf(Get.QNAME, GET_MODULES_STATE_MODULE_LIST_RPC), (FutureCallback)new FutureCallback<DOMRpcResult>(){

            public void onSuccess(DOMRpcResult result) {
                LibraryModulesSchemas.onGetModulesStateResult((SettableFuture<LibraryModulesSchemas>)future, deviceId, result);
            }

            public void onFailure(Throwable cause) {
                LOG.debug("{}: Unable to detect available schemas", (Object)deviceId, (Object)cause);
                future.setException(cause);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    private static void onGetModulesStateResult(SettableFuture<LibraryModulesSchemas> future, RemoteDeviceId deviceId, DOMRpcResult result) {
        Collection errors = result.errors();
        if (errors.stream().anyMatch(error -> error.getSeverity() == ErrorSeverity.ERROR)) {
            future.setException((Throwable)new OperationFailedException("Failed to get modules-state", errors));
            return;
        }
        for (RpcError error2 : errors) {
            LOG.info("{}: schema retrieval warning: {}", (Object)deviceId, (Object)error2);
        }
        ContainerNode value = result.value();
        if (value == null) {
            LOG.warn("{}: missing RPC output", (Object)deviceId);
            future.set((Object)EMPTY);
            return;
        }
        DataContainerChild data = (DataContainerChild)value.childByArg((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID);
        if (data == null) {
            LOG.warn("{}: missing RPC data", (Object)deviceId);
            future.set((Object)EMPTY);
            return;
        }
        future.setException((Throwable)new UnsupportedOperationException("Missing normalization logic for " + String.valueOf(data.prettyTree())));
    }

    public Map<SourceIdentifier, URL> getAvailableModels() {
        HashMap<SourceIdentifier, URL> result = new HashMap<SourceIdentifier, URL>();
        for (Map.Entry entry : this.availableModels.entrySet()) {
            SourceIdentifier sId = new SourceIdentifier(((QName)entry.getKey()).getLocalName(), (String)((QName)entry.getKey()).getRevision().map(Revision::toString).orElse(null));
            result.put(sId, (URL)entry.getValue());
        }
        return result;
    }

    public static LibraryModulesSchemas create(String url, String username, String password) {
        try {
            URL urlConnection = new URL(Objects.requireNonNull(url));
            URLConnection connection = urlConnection.openConnection();
            if (connection instanceof HttpURLConnection) {
                connection.setRequestProperty("Accept", "application/xml");
                String userpass = username + ":" + password;
                connection.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(userpass.getBytes(StandardCharsets.UTF_8)));
            }
            return LibraryModulesSchemas.createFromURLConnection(connection);
        }
        catch (IOException e) {
            LOG.warn("Unable to download yang library from {}", (Object)url, (Object)e);
            return new LibraryModulesSchemas((ImmutableMap<QName, URL>)ImmutableMap.of());
        }
    }

    private static LibraryModulesSchemas create(ContainerNode modulesStateNode) {
        Optional moduleListNode = modulesStateNode.findChildByArg((YangInstanceIdentifier.PathArgument)MODULE_NID);
        Preconditions.checkState((boolean)moduleListNode.isPresent(), (String)"Unable to find list: %s in %s", (Object)MODULE_NID, (Object)modulesStateNode);
        DataContainerChild node = (DataContainerChild)moduleListNode.orElseThrow();
        Preconditions.checkState((boolean)(node instanceof MapNode), (String)"Unexpected structure for container: %s in : %s. Expecting a list", (Object)MODULE_NID, (Object)modulesStateNode);
        MapNode moduleList = (MapNode)node;
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)moduleList.size());
        for (MapEntryNode moduleNode : moduleList.body()) {
            Map.Entry<QName, URL> entry = LibraryModulesSchemas.createFromEntry(moduleNode);
            if (entry == null) continue;
            builder.put(entry);
        }
        return new LibraryModulesSchemas((ImmutableMap<QName, URL>)builder.build());
    }

    public static LibraryModulesSchemas create(String url) {
        URLConnection connection;
        try {
            connection = new URL(Objects.requireNonNull(url)).openConnection();
        }
        catch (IOException e) {
            LOG.warn("Unable to download yang library from {}", (Object)url, (Object)e);
            return new LibraryModulesSchemas((ImmutableMap<QName, URL>)ImmutableMap.of());
        }
        if (connection instanceof HttpURLConnection) {
            connection.setRequestProperty("Accept", "application/xml");
        }
        return LibraryModulesSchemas.createFromURLConnection(connection);
    }

    private static LibraryModulesSchemas createFromURLConnection(URLConnection connection) {
        String contentType = connection.getContentType();
        if (LibraryModulesSchemas.guessJsonFromFileName(connection.getURL().getFile())) {
            contentType = "application/json";
        }
        Objects.requireNonNull(contentType, "Content type unknown");
        Preconditions.checkState((contentType.equals("application/json") || contentType.equals("application/xml") ? 1 : 0) != 0, (Object)"Only XML and JSON types are supported.");
        Optional<Object> optionalModulesStateNode = Optional.empty();
        try (InputStream in = connection.getInputStream();){
            optionalModulesStateNode = contentType.equals("application/json") ? LibraryModulesSchemas.readJson(in) : LibraryModulesSchemas.readXml(in);
        }
        catch (IOException e) {
            LOG.warn("Unable to download yang library from {}", (Object)connection.getURL(), (Object)e);
        }
        if (optionalModulesStateNode.isEmpty()) {
            return new LibraryModulesSchemas((ImmutableMap<QName, URL>)ImmutableMap.of());
        }
        NormalizedNode modulesStateNode = (NormalizedNode)optionalModulesStateNode.orElseThrow();
        Preconditions.checkState((boolean)(modulesStateNode instanceof ContainerNode), (String)"Expecting container containing module list, but was %s", (Object)modulesStateNode);
        ContainerNode modulesState = (ContainerNode)modulesStateNode;
        YangInstanceIdentifier.NodeIdentifier nodeName = modulesState.name();
        Preconditions.checkState((boolean)MODULES_STATE_NID.equals((Object)nodeName), (String)"Wrong container identifier %s", (Object)nodeName);
        return LibraryModulesSchemas.create((ContainerNode)modulesStateNode);
    }

    private static boolean guessJsonFromFileName(String fileName) {
        int i = fileName.lastIndexOf(46);
        return i != 1 && ".json".equalsIgnoreCase(fileName.substring(i));
    }

    private static Optional<NormalizedNode> readJson(InputStream in) {
        NormalizationResultHolder resultHolder = new NormalizationResultHolder();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)resultHolder);
        JsonParserStream jsonParser = JsonParserStream.create((NormalizedNodeStreamWriter)writer, (JSONCodecFactory)JSON_CODECS);
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(in, Charset.defaultCharset()));
        jsonParser.parse(reader);
        NormalizationResult result = resultHolder.result();
        return result == null ? Optional.empty() : Optional.of(result.data());
    }

    private static Optional<NormalizedNode> readXml(InputStream in) {
        try {
            DocumentBuilder docBuilder = UntrustedXML.newDocumentBuilder();
            Document read = docBuilder.parse(in);
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElementNS(ModulesState.QNAME.getNamespace().toString(), ModulesState.QNAME.getLocalName());
            doc.appendChild(rootElement);
            NodeList revisions = read.getElementsByTagName("revision");
            int length = revisions.getLength();
            for (int i = 0; i < length; ++i) {
                String revision = revisions.item(i).getTextContent();
                if (DATE_PATTERN.matcher(revision).find() || revision.isEmpty()) {
                    Node module = doc.importNode(read.getElementsByTagName("module").item(i), true);
                    rootElement.appendChild(module);
                    continue;
                }
                LOG.warn("Xml contains wrong revision - {} - on module {}", (Object)revision, (Object)read.getElementsByTagName("module").item(i).getTextContent());
            }
            NormalizationResultHolder resultHolder = new NormalizationResultHolder();
            NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizationResultHolder)resultHolder);
            XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (EffectiveStatementInference)MODULES_STATE_INFERENCE);
            xmlParser.traverse(new DOMSource(doc.getDocumentElement()));
            return Optional.of(resultHolder.getResult().data());
        }
        catch (IOException | XMLStreamException | SAXException e) {
            LOG.warn("Unable to parse yang library xml content", (Throwable)e);
            return Optional.empty();
        }
    }

    private static @Nullable Map.Entry<QName, URL> createFromEntry(MapEntryNode moduleNode) {
        String rev;
        QName moduleNodeId = moduleNode.name().getNodeType();
        Preconditions.checkArgument((boolean)moduleNodeId.equals((Object)Module.QNAME), (String)"Wrong QName %s", (Object)moduleNodeId);
        String moduleName = LibraryModulesSchemas.getSingleChildNodeValue((DataContainerNode)moduleNode, NAME_NID).orElseThrow();
        Optional<String> revision = LibraryModulesSchemas.getSingleChildNodeValue((DataContainerNode)moduleNode, REVISION_NID);
        if (revision.isPresent() && !Revision.STRING_FORMAT_PATTERN.matcher(rev = revision.orElseThrow()).matches()) {
            LOG.warn("Skipping library schema for {}. Revision {} is in wrong format.", (Object)moduleNode, (Object)rev);
            return null;
        }
        Optional<String> schemaUriAsString = LibraryModulesSchemas.getSingleChildNodeValue((DataContainerNode)moduleNode, SCHEMA_NID);
        String moduleNameSpace = LibraryModulesSchemas.getSingleChildNodeValue((DataContainerNode)moduleNode, NAMESPACE_NID).orElseThrow();
        QName moduleQName = revision.isPresent() ? QName.create((String)moduleNameSpace, (String)revision.orElseThrow(), (String)moduleName) : QName.create((XMLNamespace)XMLNamespace.of((String)moduleNameSpace), (String)moduleName);
        try {
            return Map.entry(moduleQName, new URL(schemaUriAsString.orElseThrow()));
        }
        catch (MalformedURLException e) {
            LOG.warn("Skipping library schema for {}. URL {} representing yang schema resource is not valid", (Object)moduleNode, (Object)schemaUriAsString.orElseThrow());
            return null;
        }
    }

    private static Optional<String> getSingleChildNodeValue(DataContainerNode schemaNode, YangInstanceIdentifier.NodeIdentifier childNodeId) {
        Optional node = schemaNode.findChildByArg((YangInstanceIdentifier.PathArgument)childNodeId);
        Preconditions.checkArgument((boolean)node.isPresent(), (String)"Child node %s not present", (Object)childNodeId.getNodeType());
        return LibraryModulesSchemas.getValueOfSimpleNode((NormalizedNode)node.orElseThrow());
    }

    private static Optional<String> getValueOfSimpleNode(NormalizedNode node) {
        String valueStr = node.body().toString();
        return Strings.isNullOrEmpty((String)valueStr) ? Optional.empty() : Optional.of(valueStr.trim());
    }
}

