/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.spi.source.StringYangTextSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibrarySchemaSourceProvider
implements SchemaSourceProvider<YangTextSource> {
    private static final Logger LOG = LoggerFactory.getLogger(LibrarySchemaSourceProvider.class);
    private final ImmutableMap<SourceIdentifier, URL> availableSources;

    public LibrarySchemaSourceProvider(Map<SourceIdentifier, URL> availableSources) {
        this.availableSources = ImmutableMap.copyOf(availableSources);
    }

    public ListenableFuture<? extends YangTextSource> getSource(SourceIdentifier sourceIdentifier) {
        byte[] schemaContent;
        URL url = (URL)this.availableSources.get((Object)Objects.requireNonNull(sourceIdentifier));
        Preconditions.checkArgument((url != null ? 1 : 0) != 0);
        try (InputStream in = url.openStream();){
            schemaContent = in.readAllBytes();
        }
        catch (IOException e) {
            LOG.warn("Unable to download source {} from a yang library's url {}", new Object[]{sourceIdentifier, url, e});
            return Futures.immediateFailedFuture((Throwable)new SchemaSourceException(sourceIdentifier, "Unable to download remote schema for " + String.valueOf(sourceIdentifier) + " from " + String.valueOf(url), (Throwable)e));
        }
        StringYangTextSource yangSource = new StringYangTextSource(sourceIdentifier, new String(schemaContent, StandardCharsets.UTF_8), url.toString());
        LOG.debug("Source {} downloaded from a yang library's url {}", (Object)sourceIdentifier, (Object)url);
        return Futures.immediateFuture((Object)yangSource);
    }
}

