/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.client.mdsal.DeviceMountPointContext;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceSchema;
import org.opendaylight.netconf.client.mdsal.NotificationHandler;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchema;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.DeviceActionFactory;
import org.opendaylight.netconf.client.mdsal.api.DeviceNetconfSchema;
import org.opendaylight.netconf.client.mdsal.api.DeviceNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.NetconfRpcService;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDevice;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceHandler;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformer;
import org.opendaylight.netconf.client.mdsal.spi.NetconfDeviceRpc;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Get;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscription;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.CreateSubscriptionInput;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.NetconfCapabilityChange;
import org.opendaylight.yangtools.rfc8528.model.api.SchemaMountConstants;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfDevice
implements RemoteDevice<NetconfDeviceCommunicator> {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDevice.class);
    private static final QName RFC8528_SCHEMA_MOUNTS_QNAME = QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"schema-mounts").intern();
    private static final YangInstanceIdentifier RFC8528_SCHEMA_MOUNTS = YangInstanceIdentifier.of((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)RFC8528_SCHEMA_MOUNTS_QNAME));
    protected final RemoteDeviceId id;
    private final BaseNetconfSchemaProvider baseSchemaProvider;
    private final DeviceNetconfSchemaProvider deviceSchemaProvider;
    private final Executor processingExecutor;
    private final RemoteDeviceHandler salFacade;
    private final DeviceActionFactory deviceActionFactory;
    private final NotificationHandler notificationHandler;
    private final boolean reconnectOnSchemasChange;
    private @GuardedBy(value={"this"}) ListenableFuture<?> schemaFuture;
    private @GuardedBy(value={"this"}) boolean connected = false;

    public NetconfDevice(RemoteDeviceId id, BaseNetconfSchemaProvider baseSchemaProvider, DeviceNetconfSchemaProvider deviceSchemaProvider, RemoteDeviceHandler salFacade, Executor globalProcessingExecutor, boolean reconnectOnSchemasChange) {
        this(id, baseSchemaProvider, deviceSchemaProvider, salFacade, globalProcessingExecutor, reconnectOnSchemasChange, null);
    }

    public NetconfDevice(RemoteDeviceId id, BaseNetconfSchemaProvider baseSchemaProvider, DeviceNetconfSchemaProvider deviceSchemaProvider, RemoteDeviceHandler salFacade, Executor globalProcessingExecutor, boolean reconnectOnSchemasChange, DeviceActionFactory deviceActionFactory) {
        this.id = Objects.requireNonNull(id);
        this.baseSchemaProvider = Objects.requireNonNull(baseSchemaProvider);
        this.deviceSchemaProvider = Objects.requireNonNull(deviceSchemaProvider);
        this.reconnectOnSchemasChange = reconnectOnSchemasChange;
        this.deviceActionFactory = deviceActionFactory;
        this.salFacade = salFacade;
        this.processingExecutor = Objects.requireNonNull(globalProcessingExecutor);
        this.notificationHandler = new NotificationHandler(salFacade, id);
    }

    @Override
    public synchronized void onRemoteSessionUp(final NetconfSessionPreferences remoteSessionCapabilities, final NetconfDeviceCommunicator listener) {
        ListenableFuture netconfDeviceSchemaFuture;
        this.connected = true;
        LOG.debug("{}: Session to remote device established with {}", (Object)this.id, (Object)remoteSessionCapabilities);
        final BaseNetconfSchema baseSchema = this.baseSchemaProvider.baseSchemaForCapabilities(remoteSessionCapabilities);
        NetconfDeviceRpc initRpc = new NetconfDeviceRpc(baseSchema.modelContext(), listener, new NetconfMessageTransformer(baseSchema.mountPointContext(), false, baseSchema));
        ListenableFuture<DeviceNetconfSchema> deviceSchema = this.deviceSchemaProvider.deviceNetconfSchemaFor(this.id, remoteSessionCapabilities, initRpc, baseSchema, this.processingExecutor);
        this.schemaFuture = netconfDeviceSchemaFuture = Futures.transformAsync(deviceSchema, result -> Futures.transform(this.createMountPointContext(result.modelContext(), baseSchema, listener), mount -> new NetconfDeviceSchema(result.capabilities(), (MountPointContext)mount), (Executor)this.processingExecutor), (Executor)this.processingExecutor);
        Futures.addCallback((ListenableFuture)netconfDeviceSchemaFuture, (FutureCallback)new FutureCallback<NetconfDeviceSchema>(){

            public void onSuccess(NetconfDeviceSchema result) {
                NetconfDevice.this.handleSalInitializationSuccess(listener, baseSchema, result, remoteSessionCapabilities, NetconfDevice.this.getDeviceSpecificRpc(result.mountContext(), listener, baseSchema));
            }

            public void onFailure(Throwable cause) {
                if (cause instanceof CancellationException) {
                    LOG.warn("{}: Device communicator was tear down since the schema setup started", (Object)NetconfDevice.this.id);
                } else {
                    NetconfDevice.this.handleSalInitializationFailure(listener, cause);
                }
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private void registerToBaseNetconfStream(NetconfRpcService deviceRpc, final NetconfDeviceCommunicator listener) {
        ListenableFuture<? extends DOMRpcResult> rpcResultListenableFuture = deviceRpc.invokeNetconf(CreateSubscription.QNAME, (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)CreateSubscriptionInput.QNAME)).build());
        Futures.addCallback(rpcResultListenableFuture, (FutureCallback)new FutureCallback<DOMRpcResult>(){

            public void onSuccess(DOMRpcResult domRpcResult) {
                NetconfDevice.this.notificationHandler.addNotificationFilter(notification -> {
                    if (NetconfCapabilityChange.QNAME.equals((Object)notification.getBody().name().getNodeType())) {
                        LOG.info("{}: Schemas change detected, reconnecting", (Object)NetconfDevice.this.id);
                        listener.disconnect();
                        return false;
                    }
                    return true;
                });
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Unable to subscribe to base notification stream. Schemas will not be reloaded on the fly", throwable);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private boolean shouldListenOnSchemaChange(NetconfSessionPreferences remoteSessionCapabilities) {
        return remoteSessionCapabilities.isNotificationsSupported() && this.reconnectOnSchemasChange;
    }

    private synchronized void handleSalInitializationSuccess(NetconfDeviceCommunicator listener, BaseNetconfSchema baseSchema, NetconfDeviceSchema deviceSchema, NetconfSessionPreferences remoteSessionCapabilities, RemoteDeviceServices.Rpcs deviceRpc) {
        if (!this.connected) {
            LOG.warn("{}: Device communicator was closed before schema setup finished.", (Object)this.id);
            return;
        }
        if (this.shouldListenOnSchemaChange(remoteSessionCapabilities)) {
            this.registerToBaseNetconfStream(deviceRpc, listener);
        }
        NetconfMessageTransformer messageTransformer = new NetconfMessageTransformer(deviceSchema.mountContext(), true, baseSchema);
        this.salFacade.onDeviceConnected(deviceSchema, remoteSessionCapabilities, new RemoteDeviceServices(deviceRpc, this.deviceActionFactory == null ? null : this.deviceActionFactory.createDeviceAction(messageTransformer, listener)));
        this.notificationHandler.onRemoteSchemaUp(messageTransformer);
        LOG.info("{}: Netconf connector initialized successfully", (Object)this.id);
    }

    private void handleSalInitializationFailure(RemoteDeviceCommunicator listener, Throwable cause) {
        LOG.warn("{}: Unexpected error resolving device sources", (Object)this.id, (Object)cause);
        listener.close();
        this.cleanupInitialization();
        this.salFacade.onDeviceFailed(cause);
    }

    private synchronized void cleanupInitialization() {
        this.connected = false;
        if (this.schemaFuture != null && !this.schemaFuture.isDone() && !this.schemaFuture.cancel(true)) {
            LOG.warn("The cleanup of Schema Futures for device {} was unsuccessful.", (Object)this.id);
        }
        this.notificationHandler.onRemoteSchemaDown();
    }

    private ListenableFuture<@NonNull MountPointContext> createMountPointContext(EffectiveModelContext schemaContext, BaseNetconfSchema baseSchema, NetconfDeviceCommunicator listener) {
        MountPointContext emptyContext = MountPointContext.of((EffectiveModelContext)schemaContext);
        if (schemaContext.findModule(SchemaMountConstants.RFC8528_MODULE).isEmpty()) {
            return Futures.immediateFuture((Object)emptyContext);
        }
        LOG.debug("{}: Acquiring available mount points", (Object)this.id);
        NetconfDeviceRpc deviceRpc = new NetconfDeviceRpc(schemaContext, listener, new NetconfMessageTransformer(emptyContext, false, baseSchema));
        return Futures.transform((ListenableFuture)deviceRpc.domRpcService().invokeRpc(Get.QNAME, (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_GET_NODEID).withChild(NetconfMessageTransformUtil.toFilterStructure(RFC8528_SCHEMA_MOUNTS, schemaContext)).build()), rpcResult -> this.processSchemaMounts((DOMRpcResult)rpcResult, emptyContext), (Executor)MoreExecutors.directExecutor());
    }

    private MountPointContext processSchemaMounts(DOMRpcResult rpcResult, MountPointContext emptyContext) {
        ContainerNode schemaMounts;
        Collection errors = rpcResult.errors();
        if (!errors.isEmpty()) {
            LOG.warn("{}: Schema-mounts acquisition resulted in errors {}", (Object)this.id, (Object)errors);
        }
        if ((schemaMounts = rpcResult.value()) == null) {
            LOG.debug("{}: device does not define any schema mounts", (Object)this.id);
            return emptyContext;
        }
        return DeviceMountPointContext.create(emptyContext, schemaMounts);
    }

    @Override
    public void onRemoteSessionDown() {
        this.cleanupInitialization();
        this.salFacade.onDeviceDisconnected();
    }

    @Override
    public void onNotification(NetconfMessage notification) {
        this.notificationHandler.handleNotification(notification);
    }

    protected NetconfDeviceRpc getDeviceSpecificRpc(MountPointContext result, RemoteDeviceCommunicator listener, BaseNetconfSchema schema) {
        return new NetconfDeviceRpc(result.modelContext(), listener, new NetconfMessageTransformer(result, true, schema));
    }

    public static final class EmptySchemaContextException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public EmptySchemaContextException(String message) {
            super(message);
        }
    }
}

