/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal;

import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.client.mdsal.NetconfDevice;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.DeviceActionFactory;
import org.opendaylight.netconf.client.mdsal.api.DeviceNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceHandler;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;

public final class NetconfDeviceBuilder {
    private boolean reconnectOnSchemasChange;
    private DeviceNetconfSchemaProvider deviceSchemaProvider;
    private RemoteDeviceId id;
    private RemoteDeviceHandler salFacade;
    private Executor processingExecutor;
    private DeviceActionFactory deviceActionFactory;
    private BaseNetconfSchemaProvider baseSchemaProvider;

    public @NonNull NetconfDeviceBuilder setReconnectOnSchemasChange(boolean reconnectOnSchemasChange) {
        this.reconnectOnSchemasChange = reconnectOnSchemasChange;
        return this;
    }

    public @NonNull NetconfDeviceBuilder setId(RemoteDeviceId id) {
        this.id = Objects.requireNonNull(id);
        return this;
    }

    public @NonNull NetconfDeviceBuilder setSalFacade(RemoteDeviceHandler salFacade) {
        this.salFacade = Objects.requireNonNull(salFacade);
        return this;
    }

    public @NonNull NetconfDeviceBuilder setProcessingExecutor(Executor processingExecutor) {
        this.processingExecutor = Objects.requireNonNull(processingExecutor);
        return this;
    }

    public @NonNull NetconfDeviceBuilder setDeviceActionFactory(DeviceActionFactory deviceActionFactory) {
        this.deviceActionFactory = deviceActionFactory;
        return this;
    }

    public @NonNull NetconfDeviceBuilder setBaseSchemaProvider(BaseNetconfSchemaProvider baseSchemaProvider) {
        this.baseSchemaProvider = Objects.requireNonNull(baseSchemaProvider);
        return this;
    }

    public @NonNull NetconfDeviceBuilder setDeviceSchemaProvider(DeviceNetconfSchemaProvider deviceSchemaProvider) {
        this.deviceSchemaProvider = Objects.requireNonNull(deviceSchemaProvider);
        return this;
    }

    public @NonNull NetconfDevice build() {
        return new NetconfDevice(Objects.requireNonNull(this.id, "RemoteDeviceId is not initialized"), Objects.requireNonNull(this.baseSchemaProvider, "BaseNetconfSchemaProvider is not initialized"), Objects.requireNonNull(this.deviceSchemaProvider, "DeviceNetconfSchemaProvider is not initialized"), Objects.requireNonNull(this.salFacade, "RemoteDeviceHandler is not initialized"), Objects.requireNonNull(this.processingExecutor, "Executor is not initialized"), this.reconnectOnSchemasChange, this.deviceActionFactory);
    }
}

