/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.EOFException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.api.DocumentedException;
import org.opendaylight.netconf.api.NetconfTerminationReason;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.NetconfClientSessionListener;
import org.opendaylight.netconf.client.NetconfMessageUtil;
import org.opendaylight.netconf.client.mdsal.UncancellableFuture;
import org.opendaylight.netconf.client.mdsal.UserPreferences;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDevice;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class NetconfDeviceCommunicator
implements NetconfClientSessionListener,
RemoteDeviceCommunicator {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfDeviceCommunicator.class);
    private static final VarHandle CLOSING;
    protected final RemoteDevice<NetconfDeviceCommunicator> remoteDevice;
    private final @Nullable UserPreferences overrideNetconfCapabilities;
    protected final RemoteDeviceId id;
    private final Lock sessionLock = new ReentrantLock();
    private final Semaphore semaphore;
    private final int concurentRpcMsgs;
    private final Queue<Request> requests = new ArrayDeque<Request>();
    private NetconfClientSession currentSession;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile boolean closing;

    public boolean isSessionClosing() {
        return CLOSING.getVolatile(this);
    }

    public NetconfDeviceCommunicator(RemoteDeviceId id, RemoteDevice<NetconfDeviceCommunicator> remoteDevice, int rpcMessageLimit) {
        this(id, remoteDevice, rpcMessageLimit, null);
    }

    public NetconfDeviceCommunicator(RemoteDeviceId id, RemoteDevice<NetconfDeviceCommunicator> remoteDevice, int rpcMessageLimit, @Nullable UserPreferences overrideNetconfCapabilities) {
        this.concurentRpcMsgs = rpcMessageLimit;
        this.id = id;
        this.remoteDevice = remoteDevice;
        this.overrideNetconfCapabilities = overrideNetconfCapabilities;
        this.semaphore = rpcMessageLimit > 0 ? new Semaphore(rpcMessageLimit) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSessionUp(NetconfClientSession session) {
        this.sessionLock.lock();
        try {
            LOG.debug("{}: Session established", (Object)this.id);
            this.currentSession = session;
            NetconfSessionPreferences netconfSessionPreferences = NetconfSessionPreferences.fromNetconfSession(session);
            LOG.trace("{}: Session advertised capabilities: {}", (Object)this.id, (Object)netconfSessionPreferences);
            UserPreferences localOverride = this.overrideNetconfCapabilities;
            if (localOverride != null) {
                NetconfSessionPreferences sessionPreferences = localOverride.sessionPreferences();
                netconfSessionPreferences = localOverride.overrideModuleCapabilities() ? netconfSessionPreferences.replaceModuleCaps(sessionPreferences) : netconfSessionPreferences.addModuleCaps(sessionPreferences);
                netconfSessionPreferences = localOverride.overrideNonModuleCapabilities() ? netconfSessionPreferences.replaceNonModuleCaps(sessionPreferences) : netconfSessionPreferences.addNonModuleCaps(sessionPreferences);
                LOG.debug("{}: Session capabilities overridden, capabilities that will be used: {}", (Object)this.id, (Object)netconfSessionPreferences);
            }
            this.remoteDevice.onRemoteSessionUp(netconfSessionPreferences, this);
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    public void disconnect() {
        if (this.currentSession != null && CLOSING.compareAndSet(this, false, true) && this.currentSession.isUp()) {
            this.currentSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDown(String reason) {
        if (!this.isSessionClosing()) {
            LOG.warn("It's curious that no one to close the session but tearDown is called!");
        }
        LOG.debug("Tearing down {}", (Object)reason);
        ArrayList<UncancellableFuture<RpcResult<NetconfMessage>>> futuresToCancel = new ArrayList<UncancellableFuture<RpcResult<NetconfMessage>>>();
        this.sessionLock.lock();
        try {
            if (this.currentSession != null) {
                this.currentSession = null;
                Iterator it = this.requests.iterator();
                while (it.hasNext()) {
                    Request request = (Request)it.next();
                    futuresToCancel.add(request.future);
                    it.remove();
                    if (this.semaphore == null) continue;
                    this.semaphore.release();
                }
                this.remoteDevice.onRemoteSessionDown();
            }
        }
        finally {
            this.sessionLock.unlock();
        }
        for (UncancellableFuture uncancellableFuture : futuresToCancel) {
            if (Strings.isNullOrEmpty((String)reason)) {
                uncancellableFuture.set(this.createSessionDownRpcResult());
                continue;
            }
            uncancellableFuture.set(NetconfDeviceCommunicator.createErrorRpcResult(ErrorType.TRANSPORT, reason));
        }
        CLOSING.setVolatile(this, false);
    }

    private RpcResult<NetconfMessage> createSessionDownRpcResult() {
        return NetconfDeviceCommunicator.createErrorRpcResult(ErrorType.TRANSPORT, "The netconf session to %1$s is disconnected".formatted(this.id.name()));
    }

    private static RpcResult<NetconfMessage> createErrorRpcResult(ErrorType errorType, String message) {
        return RpcResultBuilder.failed().withError(errorType, ErrorTag.OPERATION_FAILED, message).build();
    }

    public void onSessionDown(NetconfClientSession session, Exception exception) {
        if (CLOSING.compareAndSet(this, false, true)) {
            if (exception instanceof EOFException) {
                LOG.info("{}: Session went down: {}", (Object)this.id, (Object)exception.getMessage());
            } else {
                LOG.warn("{}: Session went down", (Object)this.id, (Object)exception);
            }
            this.tearDown(null);
        }
    }

    public void onSessionTerminated(NetconfClientSession session, NetconfTerminationReason reason) {
        LOG.warn("{}: Session terminated {}", (Object)this.id, (Object)reason);
        this.tearDown(reason.getErrorMessage());
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public void onMessage(NetconfClientSession session, NetconfMessage message) {
        if ("notification".equals(XmlElement.fromDomDocument((Document)message.getDocument()).getName())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}: Notification received: {}", (Object)this.id, (Object)message);
            }
            this.remoteDevice.onNotification(message);
        } else {
            this.processMessage(message);
        }
    }

    public void onError(NetconfClientSession session, Exception failure) {
        Request request = this.pollRequest();
        if (request != null) {
            request.future.set((RpcResult<NetconfMessage>)RpcResultBuilder.failed().withRpcError(NetconfDeviceCommunicator.toRpcError(new DocumentedException(failure.getMessage(), ErrorType.APPLICATION, ErrorTag.MALFORMED_MESSAGE, ErrorSeverity.ERROR))).build());
        } else {
            LOG.warn("{}: Ignoring unsolicited failure {}", (Object)this.id, (Object)failure.toString());
        }
    }

    private @Nullable Request pollRequest() {
        this.sessionLock.lock();
        try {
            Request request = this.requests.peek();
            if (request != null) {
                request = this.requests.poll();
                if (this.semaphore != null) {
                    this.semaphore.release();
                }
                Request request2 = request;
                return request2;
            }
            Request request3 = null;
            return request3;
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    private void processMessage(NetconfMessage message) {
        RpcResult result;
        String outputMsgId;
        String inputMsgId;
        Request request = this.pollRequest();
        if (request == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("{}: Ignoring unsolicited message {}", (Object)this.id, (Object)NetconfDeviceCommunicator.msgToS(message));
            }
            return;
        }
        LOG.debug("{}: Message received {}", (Object)this.id, (Object)message);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: Matched request: {} to response: {}", new Object[]{this.id, NetconfDeviceCommunicator.msgToS(request.request), NetconfDeviceCommunicator.msgToS(message)});
        }
        if (!(inputMsgId = request.request.getDocument().getDocumentElement().getAttribute("message-id")).equals(outputMsgId = message.getDocument().getDocumentElement().getAttribute("message-id"))) {
            DocumentedException ex = new DocumentedException("Response message contained unknown \"message-id\"", null, ErrorType.PROTOCOL, ErrorTag.BAD_ATTRIBUTE, ErrorSeverity.ERROR, (Map)ImmutableMap.of((Object)"actual-message-id", (Object)outputMsgId, (Object)"expected-message-id", (Object)inputMsgId));
            if (LOG.isWarnEnabled()) {
                LOG.warn("{}: Invalid request-reply match, reply message contains different message-id, request: {}, response: {}", new Object[]{this.id, NetconfDeviceCommunicator.msgToS(request.request), NetconfDeviceCommunicator.msgToS(message)});
            }
            request.future.set((RpcResult<NetconfMessage>)RpcResultBuilder.failed().withRpcError(NetconfDeviceCommunicator.toRpcError(ex)).build());
            this.processMessage(message);
            return;
        }
        if (NetconfMessageUtil.isErrorMessage((NetconfMessage)message)) {
            DocumentedException ex = DocumentedException.fromXMLDocument((Document)message.getDocument());
            if (LOG.isWarnEnabled()) {
                LOG.warn("{}: Error reply from remote device, request: {}, response: {}", new Object[]{this.id, NetconfDeviceCommunicator.msgToS(request.request), NetconfDeviceCommunicator.msgToS(message)});
            }
            result = RpcResultBuilder.failed().withRpcError(NetconfDeviceCommunicator.toRpcError(ex)).build();
        } else {
            result = RpcResultBuilder.success((Object)message).build();
        }
        request.future.set((RpcResult<NetconfMessage>)result);
    }

    private static String msgToS(NetconfMessage msg) {
        return XmlUtil.toString((Document)msg.getDocument());
    }

    private static RpcError toRpcError(DocumentedException ex) {
        String infoString;
        Map errorInfo = ex.getErrorInfo();
        if (errorInfo != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry e : errorInfo.entrySet()) {
                String tag = (String)e.getKey();
                sb.append('<').append(tag).append('>').append((String)e.getValue()).append("</").append(tag).append('>');
            }
            infoString = sb.toString();
        } else {
            infoString = "";
        }
        return ex.getErrorSeverity() == ErrorSeverity.ERROR ? RpcResultBuilder.newError((ErrorType)ex.getErrorType(), (ErrorTag)ex.getErrorTag(), (String)ex.getLocalizedMessage(), null, (String)infoString, (Throwable)ex.getCause()) : RpcResultBuilder.newWarning((ErrorType)ex.getErrorType(), (ErrorTag)ex.getErrorTag(), (String)ex.getLocalizedMessage(), null, (String)infoString, (Throwable)ex.getCause());
    }

    @Override
    public ListenableFuture<RpcResult<NetconfMessage>> sendRequest(NetconfMessage message) {
        this.sessionLock.lock();
        try {
            if (this.semaphore != null && !this.semaphore.tryAcquire()) {
                LOG.warn("Limit of concurrent rpc messages was reached (limit: {}). Rpc reply message is needed. Discarding request of Netconf device with id: {}", (Object)this.concurentRpcMsgs, (Object)this.id.name());
                ListenableFuture listenableFuture = Futures.immediateFailedFuture((Throwable)new DocumentedException("Limit of rpc messages was reached (Limit :" + this.concurentRpcMsgs + ") waiting for emptying the queue of Netconf device with id: " + this.id.name()));
                return listenableFuture;
            }
            ListenableFuture<RpcResult<NetconfMessage>> listenableFuture = this.sendRequestWithLock(message);
            return listenableFuture;
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    private ListenableFuture<RpcResult<NetconfMessage>> sendRequestWithLock(NetconfMessage message) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: Sending message {}", (Object)this.id, (Object)NetconfDeviceCommunicator.msgToS(message));
        }
        if (this.currentSession == null) {
            LOG.warn("{}: Session is disconnected, failing RPC request {}", (Object)this.id, (Object)message);
            return Futures.immediateFuture(this.createSessionDownRpcResult());
        }
        Request req = new Request(new UncancellableFuture<RpcResult<NetconfMessage>>(), message);
        this.requests.add(req);
        this.currentSession.sendMessage(req.request).addListener(future -> {
            Throwable cause = future.cause();
            if (cause != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: Failed to send request {}", new Object[]{this.id, XmlUtil.toString((Document)req.request.getDocument()), cause});
                }
                req.future.set(NetconfDeviceCommunicator.createErrorRpcResult(ErrorType.TRANSPORT, cause.getLocalizedMessage()));
            } else {
                LOG.trace("Finished sending request {}", (Object)req.request);
            }
        });
        return req.future;
    }

    static {
        try {
            CLOSING = MethodHandles.lookup().findVarHandle(NetconfDeviceCommunicator.class, "closing", Boolean.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private record Request(@NonNull UncancellableFuture<RpcResult<NetconfMessage>> future, @NonNull NetconfMessage request) {
        Request(@NonNull UncancellableFuture<RpcResult<NetconfMessage>> future, @NonNull NetconfMessage request) {
            Objects.requireNonNull(future);
            Objects.requireNonNull(request);
        }
    }
}

