/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.mdsal.api.NotificationTransformer;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceHandler;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

final class NotificationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationHandler.class);
    private final RemoteDeviceHandler salFacade;
    private final List<NetconfMessage> queue = new LinkedList<NetconfMessage>();
    private final RemoteDeviceId id;
    private boolean passNotifications = false;
    private NotificationFilter filter;
    private NotificationTransformer messageTransformer;

    NotificationHandler(RemoteDeviceHandler salFacade, RemoteDeviceId id) {
        this.salFacade = Objects.requireNonNull(salFacade);
        this.id = Objects.requireNonNull(id);
    }

    synchronized void handleNotification(NetconfMessage notification) {
        if (this.passNotifications) {
            this.passNotification(this.transformNotification(notification));
        } else {
            this.queueNotification(notification);
        }
    }

    synchronized void onRemoteSchemaUp(NotificationTransformer transformer) {
        this.messageTransformer = Objects.requireNonNull(transformer);
        this.passNotifications = true;
        for (NetconfMessage cachedNotification : this.queue) {
            this.passNotification(this.transformNotification(cachedNotification));
        }
        this.queue.clear();
    }

    private DOMNotification transformNotification(NetconfMessage cachedNotification) {
        return (DOMNotification)Preconditions.checkNotNull((Object)this.messageTransformer.toNotification(cachedNotification), (String)"%s: Unable to parse received notification: %s", (Object)this.id, (Object)cachedNotification);
    }

    private void queueNotification(NetconfMessage notification) {
        Preconditions.checkState((!this.passNotifications ? 1 : 0) != 0);
        LOG.debug("{}: Caching notification {}, remote schema not yet fully built", (Object)this.id, (Object)notification);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{}: Caching notification {}", (Object)this.id, (Object)XmlUtil.toString((Document)notification.getDocument()));
        }
        this.queue.add(notification);
    }

    private synchronized void passNotification(DOMNotification parsedNotification) {
        LOG.debug("{}: Forwarding notification {}", (Object)this.id, (Object)parsedNotification);
        if (this.filter == null || this.filter.test(parsedNotification)) {
            this.salFacade.onNotification(parsedNotification);
        }
    }

    synchronized void addNotificationFilter(NotificationFilter newFilter) {
        this.filter = newFilter;
    }

    synchronized void onRemoteSchemaDown() {
        this.queue.clear();
        this.passNotifications = false;
        this.messageTransformer = null;
    }

    @FunctionalInterface
    static interface NotificationFilter
    extends Predicate<DOMNotification> {
    }
}

