/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal;

import java.util.Objects;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCapabilities;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceCommunicator;
import org.opendaylight.netconf.client.mdsal.NetconfDeviceSchema;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchema;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDevice;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceHandler;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceServices;
import org.opendaylight.netconf.client.mdsal.impl.BaseRpcSchemalessTransformer;
import org.opendaylight.netconf.client.mdsal.impl.MessageCounter;
import org.opendaylight.netconf.client.mdsal.impl.SchemalessMessageTransformer;
import org.opendaylight.netconf.client.mdsal.spi.SchemalessNetconfDeviceRpc;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;

public class SchemalessNetconfDevice
implements RemoteDevice<NetconfDeviceCommunicator> {
    private final BaseNetconfSchemaProvider baseSchemas;
    private final RemoteDeviceId id;
    private final RemoteDeviceHandler salFacade;
    private SchemalessMessageTransformer messageTransformer;

    public SchemalessNetconfDevice(BaseNetconfSchemaProvider baseSchemas, RemoteDeviceId id, RemoteDeviceHandler salFacade) {
        this.baseSchemas = Objects.requireNonNull(baseSchemas);
        this.id = Objects.requireNonNull(id);
        this.salFacade = Objects.requireNonNull(salFacade);
    }

    @Override
    public void onRemoteSessionUp(NetconfSessionPreferences remoteSessionCapabilities, NetconfDeviceCommunicator netconfDeviceCommunicator) {
        BaseNetconfSchema baseSchema = this.baseSchemas.baseSchemaForCapabilities(remoteSessionCapabilities);
        MountPointContext mountContext = baseSchema.mountPointContext();
        MessageCounter counter = new MessageCounter();
        BaseRpcSchemalessTransformer rpcTransformer = new BaseRpcSchemalessTransformer(baseSchema, counter);
        this.messageTransformer = new SchemalessMessageTransformer(counter);
        this.salFacade.onDeviceConnected(new NetconfDeviceSchema(NetconfDeviceCapabilities.empty(), mountContext), remoteSessionCapabilities, new RemoteDeviceServices(new SchemalessNetconfDeviceRpc(this.id, netconfDeviceCommunicator, rpcTransformer, this.messageTransformer), null));
    }

    @Override
    public void onRemoteSessionDown() {
        this.salFacade.onDeviceDisconnected();
        this.messageTransformer = null;
    }

    @Override
    public void onNotification(NetconfMessage notification) {
        this.salFacade.onNotification(this.messageTransformer.toNotification(notification));
    }
}

