/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.api;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.netconf.client.NetconfClientSession;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.SessionIdType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.oper.available.capabilities.AvailableCapability;
import org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record NetconfSessionPreferences(@NonNull ImmutableMap<String, AvailableCapability.CapabilityOrigin> nonModuleCaps, @NonNull ImmutableMap<QName, AvailableCapability.CapabilityOrigin> moduleBasedCaps, @Nullable SessionIdType sessionId) {
    private static final Logger LOG = LoggerFactory.getLogger(NetconfSessionPreferences.class);
    private static final ParameterMatcher MODULE_PARAM = new ParameterMatcher("module=");
    private static final ParameterMatcher REVISION_PARAM = new ParameterMatcher("revision=");
    private static final ParameterMatcher BROKEN_REVISON_PARAM = new ParameterMatcher("amp;revision=");
    private static final Splitter AMP_SPLITTER = Splitter.on((char)'&');

    public NetconfSessionPreferences(@NonNull ImmutableMap<String, AvailableCapability.CapabilityOrigin> nonModuleCaps, @NonNull ImmutableMap<QName, AvailableCapability.CapabilityOrigin> moduleBasedCaps, @Nullable SessionIdType sessionId) {
        Objects.requireNonNull(nonModuleCaps);
        Objects.requireNonNull(moduleBasedCaps);
    }

    public static @NonNull NetconfSessionPreferences fromNetconfSession(NetconfClientSession session) {
        return NetconfSessionPreferences.fromStrings(session.getServerCapabilities(), AvailableCapability.CapabilityOrigin.DeviceAdvertised, session.sessionId());
    }

    @VisibleForTesting
    public static @NonNull NetconfSessionPreferences fromStrings(Collection<String> capabilities) {
        return NetconfSessionPreferences.fromStrings(capabilities, AvailableCapability.CapabilityOrigin.DeviceAdvertised, null);
    }

    public static @NonNull NetconfSessionPreferences fromStrings(Collection<String> capabilities, AvailableCapability.CapabilityOrigin capabilityOrigin, SessionIdType sessionId) {
        HashMap<QName, AvailableCapability.CapabilityOrigin> moduleBasedCaps = new HashMap<QName, AvailableCapability.CapabilityOrigin>();
        HashMap<String, AvailableCapability.CapabilityOrigin> nonModuleCaps = new HashMap<String, AvailableCapability.CapabilityOrigin>();
        for (String capability : capabilities) {
            nonModuleCaps.put(capability, capabilityOrigin);
            int qmark = capability.indexOf(63);
            if (qmark == -1) continue;
            String namespace = capability.substring(0, qmark);
            Iterable queryParams = AMP_SPLITTER.split((CharSequence)capability.substring(qmark + 1));
            String moduleName = MODULE_PARAM.from(queryParams);
            if (Strings.isNullOrEmpty((String)moduleName)) continue;
            String revision = REVISION_PARAM.from(queryParams);
            if (!Strings.isNullOrEmpty((String)revision)) {
                NetconfSessionPreferences.addModuleQName(moduleBasedCaps, nonModuleCaps, capability, NetconfSessionPreferences.cachedQName(namespace, revision, moduleName), capabilityOrigin);
                continue;
            }
            if (Iterables.any((Iterable)queryParams, input -> input.contains("revision="))) {
                LOG.debug("Netconf device was not reporting revision correctly, trying to get amp;revision=");
                revision = BROKEN_REVISON_PARAM.from(queryParams);
                if (Strings.isNullOrEmpty((String)revision)) {
                    LOG.warn("Netconf device returned revision incorrectly escaped for {}, ignoring it", (Object)capability);
                    NetconfSessionPreferences.addModuleQName(moduleBasedCaps, nonModuleCaps, capability, NetconfSessionPreferences.cachedQName(namespace, moduleName), capabilityOrigin);
                    continue;
                }
                NetconfSessionPreferences.addModuleQName(moduleBasedCaps, nonModuleCaps, capability, NetconfSessionPreferences.cachedQName(namespace, revision, moduleName), capabilityOrigin);
                continue;
            }
            NetconfSessionPreferences.addModuleQName(moduleBasedCaps, nonModuleCaps, capability, NetconfSessionPreferences.cachedQName(namespace, moduleName), capabilityOrigin);
        }
        return new NetconfSessionPreferences((ImmutableMap<String, AvailableCapability.CapabilityOrigin>)ImmutableMap.copyOf(nonModuleCaps), (ImmutableMap<QName, AvailableCapability.CapabilityOrigin>)ImmutableMap.copyOf(moduleBasedCaps), sessionId);
    }

    public  @Nullable AvailableCapability.CapabilityOrigin capabilityOrigin(QName capability) {
        return (AvailableCapability.CapabilityOrigin)((Object)this.moduleBasedCaps.get((Object)Objects.requireNonNull(capability)));
    }

    public  @Nullable AvailableCapability.CapabilityOrigin capabilityOrigin(String capability) {
        return (AvailableCapability.CapabilityOrigin)((Object)this.nonModuleCaps.get((Object)Objects.requireNonNull(capability)));
    }

    public boolean containsPartialNonModuleCapability(String capability) {
        for (String nonModuleCap : this.nonModuleCaps.keySet()) {
            if (!nonModuleCap.startsWith(capability)) continue;
            LOG.trace("capability {} partially matches {}", (Object)capability, this.nonModuleCaps);
            return true;
        }
        return false;
    }

    public boolean containsNonModuleCapability(String capability) {
        return this.nonModuleCaps.containsKey((Object)capability);
    }

    public boolean containsModuleCapability(QName capability) {
        return this.moduleBasedCaps.containsKey((Object)capability);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("capabilities", this.nonModuleCaps).add("moduleBasedCapabilities", this.moduleBasedCaps).add("rollback", this.isRollbackSupported()).add("monitoring", this.isMonitoringSupported()).add("candidate", this.isCandidateSupported()).add("writableRunning", this.isRunningWritable()).toString();
    }

    public boolean isRollbackSupported() {
        return this.containsNonModuleCapability("urn:ietf:params:netconf:capability:rollback-on-error:1.0");
    }

    public boolean isCandidateSupported() {
        return this.containsNonModuleCapability("urn:ietf:params:netconf:capability:candidate:1.0");
    }

    public boolean isRunningWritable() {
        return this.containsNonModuleCapability("urn:ietf:params:netconf:capability:writable-running:1.0");
    }

    public boolean isNotificationsSupported() {
        return this.containsPartialNonModuleCapability("urn:ietf:params:netconf:capability:notification:1.0") || this.containsModuleCapability(YangModuleInfoImpl.getInstance().getName());
    }

    public boolean isMonitoringSupported() {
        return this.containsModuleCapability(NetconfMessageTransformUtil.IETF_NETCONF_MONITORING) || this.containsPartialNonModuleCapability(NetconfMessageTransformUtil.IETF_NETCONF_MONITORING.getNamespace().toString());
    }

    public NetconfSessionPreferences addModuleCaps(NetconfSessionPreferences netconfSessionModuleCapabilities) {
        HashMap mergedCaps = Maps.newHashMapWithExpectedSize((int)(this.moduleBasedCaps.size() + netconfSessionModuleCapabilities.moduleBasedCaps.size()));
        mergedCaps.putAll(this.moduleBasedCaps);
        mergedCaps.putAll(netconfSessionModuleCapabilities.moduleBasedCaps);
        return new NetconfSessionPreferences(this.nonModuleCaps, (ImmutableMap<QName, AvailableCapability.CapabilityOrigin>)ImmutableMap.copyOf((Map)mergedCaps), netconfSessionModuleCapabilities.sessionId());
    }

    public NetconfSessionPreferences replaceModuleCaps(NetconfSessionPreferences netconfSessionPreferences) {
        return new NetconfSessionPreferences(this.nonModuleCaps, netconfSessionPreferences.moduleBasedCaps, netconfSessionPreferences.sessionId());
    }

    public NetconfSessionPreferences replaceModuleCaps(Map<QName, AvailableCapability.CapabilityOrigin> newModuleBasedCaps) {
        return new NetconfSessionPreferences(this.nonModuleCaps, (ImmutableMap<QName, AvailableCapability.CapabilityOrigin>)ImmutableMap.copyOf(newModuleBasedCaps), this.sessionId());
    }

    public NetconfSessionPreferences addNonModuleCaps(NetconfSessionPreferences netconfSessionNonModuleCapabilities) {
        HashMap mergedCaps = Maps.newHashMapWithExpectedSize((int)(this.nonModuleCaps.size() + netconfSessionNonModuleCapabilities.nonModuleCaps.size()));
        mergedCaps.putAll(this.nonModuleCaps);
        mergedCaps.putAll(netconfSessionNonModuleCapabilities.nonModuleCaps);
        return new NetconfSessionPreferences((ImmutableMap<String, AvailableCapability.CapabilityOrigin>)ImmutableMap.copyOf((Map)mergedCaps), this.moduleBasedCaps, netconfSessionNonModuleCapabilities.sessionId());
    }

    public NetconfSessionPreferences replaceNonModuleCaps(NetconfSessionPreferences netconfSessionPreferences) {
        return new NetconfSessionPreferences(netconfSessionPreferences.nonModuleCaps, this.moduleBasedCaps, netconfSessionPreferences.sessionId());
    }

    private static QName cachedQName(String namespace, String revision, String moduleName) {
        return QName.create((String)namespace, (String)revision, (String)moduleName).intern();
    }

    private static QName cachedQName(String namespace, String moduleName) {
        return QName.create((XMLNamespace)XMLNamespace.of((String)namespace), (String)moduleName).withoutRevision().intern();
    }

    private static void addModuleQName(Map<QName, AvailableCapability.CapabilityOrigin> moduleBasedCaps, Map<String, AvailableCapability.CapabilityOrigin> nonModuleCaps, String capability, QName qualifiedName, AvailableCapability.CapabilityOrigin capabilityOrigin) {
        moduleBasedCaps.put(qualifiedName, capabilityOrigin);
        nonModuleCaps.remove(capability);
    }

    private static final class ParameterMatcher {
        private final Predicate<String> predicate = input -> input.startsWith(name);
        private final int skipLength;

        ParameterMatcher(String name) {
            this.skipLength = name.length();
        }

        String from(Iterable<String> params) {
            Optional found = Iterables.tryFind(params, this.predicate);
            if (!found.isPresent()) {
                return null;
            }
            return ((String)found.get()).substring(this.skipLength);
        }
    }
}

