/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.api;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.SourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;

@NonNullByDefault
public record ProvidedSources<T extends SourceRepresentation>(Class<T> representation, SchemaSourceProvider<T> provider, Set<QName> sources) {
    public ProvidedSources {
        representation = Objects.requireNonNull(representation);
        provider = Objects.requireNonNull(provider);
        sources = Set.copyOf(sources);
    }

    public Stream<Registration> registerWith(SchemaSourceRegistry registry, int cost) {
        return this.sources.stream().map(qname -> new SourceIdentifier(qname.getLocalName(), (Revision)qname.getRevision().orElse(null))).map(sourceId -> registry.registerSchemaSource(this.provider, PotentialSchemaSource.create((SourceIdentifier)sourceId, this.representation, (int)cost)));
    }
}

