/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.api;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.DomainName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IetfInetUtil;

public record RemoteDeviceId(@NonNull String name, @NonNull InetSocketAddress address) {
    public RemoteDeviceId(@NonNull String name, @NonNull InetSocketAddress address) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(address);
    }

    public @NonNull Host host() {
        InetAddress addr = this.address.getAddress();
        return addr != null ? new Host(IetfInetUtil.ipAddressFor((InetAddress)addr)) : new Host(new DomainName(this.address.getHostString()));
    }
}

