/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.netconf.api.messages.NetconfMessage;
import org.opendaylight.netconf.api.xml.XmlElement;
import org.opendaylight.netconf.api.xml.XmlUtil;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchema;
import org.opendaylight.netconf.client.mdsal.api.RpcTransformer;
import org.opendaylight.netconf.client.mdsal.impl.MessageCounter;
import org.opendaylight.netconf.client.mdsal.impl.NetconfMessageTransformUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaseRpcSchemalessTransformer
implements RpcTransformer<NormalizedNode, DOMRpcResult> {
    private final BaseNetconfSchema baseSchema;
    private final MessageCounter counter;

    public BaseRpcSchemalessTransformer(BaseNetconfSchema baseSchema, MessageCounter counter) {
        this.baseSchema = Objects.requireNonNull(baseSchema);
        this.counter = Objects.requireNonNull(counter);
    }

    @Override
    public NetconfMessage toRpcRequest(QName rpc, NormalizedNode payload) {
        ImmutableMap<QName, ? extends RpcDefinition> mappedRpcs = this.baseSchema.mappedRpcs();
        RpcDefinition mappedRpc = (RpcDefinition)Preconditions.checkNotNull((Object)((RpcDefinition)mappedRpcs.get((Object)rpc)), (String)"Unknown rpc %s, available rpcs: %s", (Object)rpc, (Object)mappedRpcs.keySet());
        DOMResult domResult = NetconfMessageTransformUtil.prepareDomResultForRpcRequest(rpc, this.counter);
        if (mappedRpc.getInput().getChildNodes().isEmpty()) {
            return new NetconfMessage(domResult.getNode().getOwnerDocument());
        }
        Preconditions.checkNotNull((Object)payload, (String)"Transforming an rpc with input: %s, payload cannot be null", (Object)rpc);
        Preconditions.checkArgument((boolean)(payload instanceof ContainerNode), (String)"Transforming an rpc with input: %s, payload has to be a container, but was: %s", (Object)rpc, (Object)payload);
        DOMResult result = domResult;
        try {
            NetconfMessageTransformUtil.writeNormalizedOperationInput((ContainerNode)payload, result, SchemaNodeIdentifier.Absolute.of((QName)rpc), this.baseSchema.modelContext());
        }
        catch (IOException | IllegalStateException | XMLStreamException e) {
            throw new IllegalStateException("Unable to serialize input of " + String.valueOf(rpc), e);
        }
        Document node = result.getNode().getOwnerDocument();
        return new NetconfMessage(node);
    }

    @Override
    public DOMRpcResult toRpcResult(RpcResult<NetconfMessage> resultPayload, QName rpc) {
        ContainerNode normalizedNode;
        if (!resultPayload.isSuccessful()) {
            return new DefaultDOMRpcResult((Collection)resultPayload.getErrors());
        }
        NetconfMessage message = (NetconfMessage)resultPayload.getResult();
        if (NetconfMessageTransformUtil.isDataRetrievalOperation(rpc)) {
            Element xmlData = NetconfMessageTransformUtil.getDataSubtree(message.getDocument());
            Document data = XmlUtil.newDocument();
            data.appendChild(data.importNode(xmlData, true));
            normalizedNode = (ContainerNode)ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_RPC_REPLY_NODEID).withChild((DataContainerChild)ImmutableNodes.newAnyxmlBuilder(DOMSource.class).withNodeIdentifier((YangInstanceIdentifier.PathArgument)NetconfMessageTransformUtil.NETCONF_DATA_NODEID).withValue((Object)new DOMSource(data)).build()).build();
        } else {
            Preconditions.checkArgument((boolean)BaseRpcSchemalessTransformer.isOkPresent(message.getDocument()), (String)"Unexpected content in response of rpc: %s, %s", (Object)rpc, (Object)message);
            normalizedNode = null;
        }
        return new DefaultDOMRpcResult(normalizedNode);
    }

    static boolean isOkPresent(Document doc) {
        return XmlElement.fromDomDocument((Document)doc).getOnlyChildElementWithSameNamespaceOptionally("ok").isPresent();
    }
}

