/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.base.Stopwatch;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.impl.DefaultBaseNetconfSchema;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Candidate;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.ConfirmedCommit;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.IetfNetconfData;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.RollbackOnError;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Startup;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Url;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Validate;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.WritableRunning;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.Xpath;
import org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.notifications.rev120206.YangModuleInfoImpl;
import org.opendaylight.yangtools.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.yangtools.binding.runtime.spi.ModuleInfoSnapshotBuilder;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component
public final class DefaultBaseNetconfSchemaProvider
implements BaseNetconfSchemaProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBaseNetconfSchemaProvider.class);
    private final LoadingCache<Capabilities, DefaultBaseNetconfSchema> baseSchemas = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<Capabilities, DefaultBaseNetconfSchema>(){

        public DefaultBaseNetconfSchema load(Capabilities key) throws YangParserException {
            LOG.debug("Loading base schema for {}", (Object)key);
            Stopwatch sw = Stopwatch.createStarted();
            ModuleInfoSnapshotBuilder builder = new ModuleInfoSnapshotBuilder(DefaultBaseNetconfSchemaProvider.this.parserFactory).add(org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.netconf.base._1._0.rev110601.YangModuleInfoImpl.getInstance());
            ImmutableSet.Builder netconfFeatures = ImmutableSet.builder();
            if (key.writableRunning) {
                netconfFeatures.add((Object)WritableRunning.VALUE);
            }
            if (key.candidate) {
                netconfFeatures.add((Object)Candidate.VALUE);
            }
            if (key.confirmedCommit) {
                netconfFeatures.add((Object)ConfirmedCommit.VALUE);
            }
            if (key.rollbackOnError) {
                netconfFeatures.add((Object)RollbackOnError.VALUE);
            }
            if (key.validate) {
                netconfFeatures.add((Object)Validate.F.VALUE);
            }
            if (key.startup) {
                netconfFeatures.add((Object)Startup.VALUE);
            }
            if (key.url) {
                netconfFeatures.add((Object)Url.VALUE);
            }
            if (key.xpath) {
                netconfFeatures.add((Object)Xpath.VALUE);
            }
            builder.addModuleFeatures(IetfNetconfData.class, (Set)netconfFeatures.build());
            if (key.library) {
                builder.add(org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev190104.YangModuleInfoImpl.getInstance());
            }
            if (key.monitoring) {
                builder.add(org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.YangModuleInfoImpl.getInstance());
            }
            if (key.notifications) {
                builder.add(org.opendaylight.yang.svc.v1.urn.ietf.params.xml.ns.netconf.notification._1._0.rev080714.YangModuleInfoImpl.getInstance()).add(YangModuleInfoImpl.getInstance());
            }
            ModuleInfoSnapshot snapshot = builder.build();
            LOG.debug("Schema for {} assembled in {}", (Object)key, (Object)sw);
            return new DefaultBaseNetconfSchema(snapshot.modelContext());
        }
    });
    private final YangParserFactory parserFactory;

    @Inject
    @Activate
    public DefaultBaseNetconfSchemaProvider(@Reference YangParserFactory parserFactory) {
        this.parserFactory = Objects.requireNonNull(parserFactory);
    }

    @Override
    public DefaultBaseNetconfSchema baseSchemaForCapabilities(NetconfSessionPreferences sessionPreferences) {
        return (DefaultBaseNetconfSchema)this.baseSchemas.getUnchecked((Object)new Capabilities(sessionPreferences.isRunningWritable(), sessionPreferences.isCandidateSupported(), sessionPreferences.containsNonModuleCapability("urn:ietf:params:netconf:capability:confirmed-commit:1.1") || sessionPreferences.containsNonModuleCapability("urn:ietf:params:netconf:capability:confirmed-commit:1.0"), sessionPreferences.isRollbackSupported(), sessionPreferences.containsNonModuleCapability("urn:ietf:params:netconf:capability:validate:1.1") || sessionPreferences.containsNonModuleCapability("urn:ietf:params:netconf:capability:validate:1.0"), sessionPreferences.containsNonModuleCapability("urn:ietf:params:netconf:capability:startup:1.0"), sessionPreferences.containsNonModuleCapability("urn:ietf:params:netconf:capability:url:1.0"), sessionPreferences.containsNonModuleCapability("urn:ietf:params:netconf:capability:xpath:1.0"), sessionPreferences.isNotificationsSupported(), sessionPreferences.containsNonModuleCapability("urn:ietf:params:netconf:capability:yang-library:1.0") || sessionPreferences.containsNonModuleCapability("urn:ietf:params:netconf:capability:yang-library:1.1"), sessionPreferences.isMonitoringSupported()));
    }

    private record Capabilities(boolean writableRunning, boolean candidate, boolean confirmedCommit, boolean rollbackOnError, boolean validate, boolean startup, boolean url, boolean xpath, boolean notifications, boolean library, boolean monitoring) {
    }
}

