/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import java.security.KeyPair;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.client.mdsal.api.CredentialProvider;
import org.opendaylight.netconf.keystore.legacy.NetconfKeystoreService;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Singleton
@Component(service={CredentialProvider.class})
public final class DefaultCredentialProvider
implements CredentialProvider,
AutoCloseable {
    private final @NonNull Registration reg;
    private volatile @NonNull Map<String, KeyPair> credentials = Map.of();

    @Inject
    @Activate
    public DefaultCredentialProvider(@Reference NetconfKeystoreService keystoreService) {
        this.reg = keystoreService.registerKeystoreConsumer(keystore -> {
            this.credentials = keystore.credentials();
        });
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.reg.close();
    }

    @Override
    public KeyPair credentialForId(String id) {
        return this.credentials.get(Objects.requireNonNull(id));
    }
}

