/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.client.mdsal.api.BaseNetconfSchema;
import org.opendaylight.netconf.client.mdsal.api.DeviceNetconfSchema;
import org.opendaylight.netconf.client.mdsal.api.DeviceNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.NetconfDeviceSchemas;
import org.opendaylight.netconf.client.mdsal.api.NetconfDeviceSchemasResolver;
import org.opendaylight.netconf.client.mdsal.api.NetconfRpcService;
import org.opendaylight.netconf.client.mdsal.api.NetconfSessionPreferences;
import org.opendaylight.netconf.client.mdsal.api.RemoteDeviceId;
import org.opendaylight.netconf.client.mdsal.impl.NetconfStateSchemasResolverImpl;
import org.opendaylight.netconf.client.mdsal.impl.SchemaSetup;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.model.repo.api.EffectiveModelContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactoryConfiguration;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public final class DefaultDeviceNetconfSchemaProvider
implements DeviceNetconfSchemaProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDeviceNetconfSchemaProvider.class);
    private final NetconfDeviceSchemasResolver resolver = new NetconfStateSchemasResolverImpl();
    private final @NonNull EffectiveModelContextFactory contextFactory;
    private final @NonNull SchemaSourceRegistry registry;
    private final @NonNull SchemaRepository repository;

    DefaultDeviceNetconfSchemaProvider(SharedSchemaRepository repository) {
        this((SchemaSourceRegistry)repository, (SchemaRepository)repository, repository.createEffectiveModelContextFactory(SchemaContextFactoryConfiguration.getDefault()));
    }

    @VisibleForTesting
    public DefaultDeviceNetconfSchemaProvider(SchemaSourceRegistry registry, SchemaRepository repository, EffectiveModelContextFactory contextFactory) {
        this.registry = Objects.requireNonNull(registry);
        this.repository = Objects.requireNonNull(repository);
        this.contextFactory = Objects.requireNonNull(contextFactory);
    }

    @Override
    public ListenableFuture<DeviceNetconfSchema> deviceNetconfSchemaFor(RemoteDeviceId deviceId, NetconfSessionPreferences sessionPreferences, NetconfRpcService deviceRpc, BaseNetconfSchema baseSchema, Executor processingExecutor) {
        ListenableFuture<NetconfDeviceSchemas> sourceResolverFuture = this.resolver.resolve(deviceId, sessionPreferences, deviceRpc, baseSchema.modelContext());
        return Futures.transformAsync(sourceResolverFuture, deviceSources -> {
            LOG.debug("{}: Resolved device sources to {}", (Object)deviceId, deviceSources);
            List registrations = deviceSources.providedSources().stream().flatMap(sources -> sources.registerWith(this.registry, PotentialSchemaSource.Costs.REMOTE_IO.getValue())).collect(Collectors.toUnmodifiableList());
            ListenableFuture<DeviceNetconfSchema> future = new SchemaSetup(this.repository, this.contextFactory, deviceId, (NetconfDeviceSchemas)deviceSources, sessionPreferences).startResolution();
            future.addListener(() -> registrations.forEach(Registration::close), processingExecutor);
            return future;
        }, (Executor)processingExecutor);
    }

    @Override
    @Deprecated
    public SchemaRepository repository() {
        return this.repository;
    }

    @Override
    @Deprecated
    public SchemaSourceRegistry registry() {
        return this.registry;
    }

    @Override
    @Deprecated
    public EffectiveModelContextFactory contextFactory() {
        return this.contextFactory;
    }
}

