/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.client.mdsal.api.DeviceNetconfSchemaProvider;
import org.opendaylight.netconf.client.mdsal.api.SchemaResourceManager;
import org.opendaylight.netconf.client.mdsal.impl.DefaultDeviceNetconfSchemaProvider;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.fs.FilesystemSchemaSourceCache;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.spi.SoftSchemaSourceCache;
import org.opendaylight.yangtools.yang.model.spi.source.YangIRSource;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.TextToIRTransformer;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.RequireServiceComponentRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Beta
@Component(immediate=true)
@RequireServiceComponentRuntime
public final class DefaultSchemaResourceManager
implements SchemaResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaResourceManager.class);
    private final @GuardedBy(value={"this"}) Map<String, DeviceNetconfSchemaProvider> resources = new HashMap<String, DeviceNetconfSchemaProvider>();
    private final @NonNull DeviceNetconfSchemaProvider defaultResources;
    private final YangParserFactory parserFactory;
    private final String defaultSubdirectory;
    private final String rootDirectory;

    @Inject
    @Activate
    public DefaultSchemaResourceManager(@Reference YangParserFactory parserFactory) {
        this(parserFactory, "cache", "schema");
    }

    public DefaultSchemaResourceManager(YangParserFactory parserFactory, String rootDirectory, String defaultSubdirectory) {
        this.parserFactory = Objects.requireNonNull(parserFactory);
        this.rootDirectory = Objects.requireNonNull(rootDirectory);
        this.defaultSubdirectory = Objects.requireNonNull(defaultSubdirectory);
        this.defaultResources = this.createResources(defaultSubdirectory);
        LOG.info("Schema Resource Manager instantiated on {}/{}", (Object)rootDirectory, (Object)defaultSubdirectory);
    }

    @Override
    public DeviceNetconfSchemaProvider getSchemaResources(String subdir, Object nodeId) {
        if (this.defaultSubdirectory.equals(subdir)) {
            return this.defaultResources;
        }
        if (Strings.isNullOrEmpty((String)subdir)) {
            LOG.warn("schema-cache-directory for {} is null or empty;  using the default {}", nodeId, (Object)this.defaultSubdirectory);
            return this.defaultResources;
        }
        LOG.info("Netconf connector for device {} will use schema cache directory {} instead of {}", new Object[]{nodeId, subdir, this.defaultSubdirectory});
        return this.getSchemaResources(subdir);
    }

    private synchronized @NonNull DeviceNetconfSchemaProvider getSchemaResources(String subdir) {
        DeviceNetconfSchemaProvider existing = this.resources.get(subdir);
        if (existing != null) {
            return existing;
        }
        DeviceNetconfSchemaProvider created = this.createResources(subdir);
        this.resources.put(subdir, created);
        return created;
    }

    private @NonNull DeviceNetconfSchemaProvider createResources(String subdir) {
        SharedSchemaRepository repository = new SharedSchemaRepository(subdir, this.parserFactory);
        repository.registerSchemaSourceListener((SchemaSourceListener)TextToIRTransformer.create((SchemaRepository)repository, (SchemaSourceRegistry)repository));
        repository.registerSchemaSourceListener((SchemaSourceListener)new SoftSchemaSourceCache((SchemaSourceRegistry)repository, YangIRSource.class));
        repository.registerSchemaSourceListener((SchemaSourceListener)new FilesystemSchemaSourceCache((SchemaSourceRegistry)repository, YangTextSource.class, new File(this.rootDirectory + File.separator + subdir)));
        return new DefaultDeviceNetconfSchemaProvider(repository);
    }
}

