/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.client.SslContextFactory;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSslContextFactoryProvider;

class DefaultSslContextFactory
implements SslContextFactory {
    private final DefaultSslContextFactoryProvider keyStoreProvider;

    DefaultSslContextFactory(DefaultSslContextFactoryProvider keyStoreProvider) {
        this.keyStoreProvider = Objects.requireNonNull(keyStoreProvider);
    }

    public final SslContext createSslContext(Set<String> allowedKeys) {
        SSLContext sslContext;
        try {
            KeyStore keyStore = this.keyStoreProvider.getJavaKeyStore(allowedKeys);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, "".toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Failed to initialize SSL context", e);
        }
        return this.wrapSslContext((SslContext)new JdkSslContext(sslContext, true, ClientAuth.NONE));
    }

    @NonNull SslContext wrapSslContext(@NonNull SslContext sslContext) {
        return sslContext;
    }
}

