/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.netconf.client.SslContextFactory;
import org.opendaylight.netconf.client.mdsal.api.SslContextFactoryProvider;
import org.opendaylight.netconf.client.mdsal.impl.DefaultSslContextFactory;
import org.opendaylight.netconf.client.mdsal.impl.FilteredSslContextFactory;
import org.opendaylight.netconf.keystore.legacy.CertifiedPrivateKey;
import org.opendaylight.netconf.keystore.legacy.NetconfKeystore;
import org.opendaylight.netconf.keystore.legacy.NetconfKeystoreService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.protocol.Specification;
import org.opendaylight.yang.gen.v1.urn.opendaylight.netconf.device.rev241009.connection.parameters.protocol.specification.TlsCase;
import org.opendaylight.yangtools.concepts.Registration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Singleton
@Component(service={SslContextFactoryProvider.class})
public final class DefaultSslContextFactoryProvider
implements SslContextFactoryProvider,
AutoCloseable {
    private static final X509Certificate[] EMPTY_CERTS = new X509Certificate[0];
    private static final char[] EMPTY_CHARS = new char[0];
    private final @NonNull DefaultSslContextFactory nospecFactory = new DefaultSslContextFactory(this);
    private final Registration reg;
    private volatile @NonNull NetconfKeystore keystore = NetconfKeystore.EMPTY;

    @Inject
    @Activate
    public DefaultSslContextFactoryProvider(@Reference NetconfKeystoreService keystoreService) {
        this.reg = keystoreService.registerKeystoreConsumer(this::onKeystoreUpdated);
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.reg.close();
    }

    private void onKeystoreUpdated(@NonNull NetconfKeystore newKeystore) {
        this.keystore = newKeystore;
    }

    @Override
    public SslContextFactory getSslContextFactory(Specification specification) {
        if (specification == null) {
            return this.nospecFactory;
        }
        if (specification instanceof TlsCase) {
            TlsCase tlsSpecification = (TlsCase)specification;
            Set<String> excludedVersions = tlsSpecification.nonnullTls().getExcludedVersions();
            return excludedVersions == null || excludedVersions.isEmpty() ? this.nospecFactory : new FilteredSslContextFactory(this, excludedVersions);
        }
        throw new IllegalArgumentException("Cannot get TLS specification from: " + String.valueOf(specification));
    }

    KeyStore getJavaKeyStore(Set<String> allowedKeys) throws GeneralSecurityException, IOException {
        Objects.requireNonNull(allowedKeys);
        NetconfKeystore current = this.keystore;
        if (current.privateKeys().isEmpty()) {
            throw new KeyStoreException("No keystore private key found");
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        for (Map.Entry entry : current.privateKeys().entrySet()) {
            String alias = (String)entry.getKey();
            if (!allowedKeys.isEmpty() && !allowedKeys.contains(alias)) continue;
            CertifiedPrivateKey privateKey = (CertifiedPrivateKey)entry.getValue();
            keyStore.setKeyEntry(alias, privateKey.key(), EMPTY_CHARS, privateKey.certificateChain().toArray(EMPTY_CERTS));
        }
        for (Map.Entry entry : current.trustedCertificates().entrySet()) {
            keyStore.setCertificateEntry((String)entry.getKey(), (Certificate)entry.getValue());
        }
        return keyStore;
    }
}

