/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.client.mdsal.impl;

import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.SslContext;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLEngine;

final class FilteredSslContext
extends DelegatingSslContext {
    private final Set<String> excludedVersions;

    FilteredSslContext(SslContext ctx, Set<String> excludedVersions) {
        super(ctx);
        this.excludedVersions = Objects.requireNonNull(excludedVersions);
    }

    protected void initEngine(SSLEngine engine) {
        engine.setEnabledProtocols((String[])Arrays.stream(engine.getSupportedProtocols()).filter(protocol -> !this.excludedVersions.contains(protocol)).toArray(String[]::new));
        engine.setEnabledCipherSuites(engine.getSupportedCipherSuites());
        engine.setEnableSessionCreation(true);
    }
}

